import java.util.regex.Pattern
import java.util.regex.Matcher
import java.util.regex.Pattern

import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

File chefTmpDir = null;

try {
	def nodeJson = props['nodejson'];
	def cookbookName = props['cookbook'];
	
	System.out.println("workDir: " + workDir.canonicalFile);
	
	// Extract name from metadata if not supplied
	if (cookbookName == null || cookbookName.empty) {
		Pattern p = Pattern.compile("name(?:\\s*)['\"](.*)['\"]");
		def metaDataFile = new File(workDir, "metadata.rb");
		if (metaDataFile.exists()) {
			metaDataFile.withReader { reader ->
				Iterator i = reader.iterator();
				while (i.hasNext()) {
					Matcher m = p.matcher(i.next());
					if (m.matches()) {
						cookbookName = m.group(1);
						break;
					}
				}
			}
		}
	}
	
	if (cookbookName == null || cookbookName.empty) {
		throw new RuntimeException("Cookbook name not specified.");
	}
	
	System.out.println("Executing cookbook '" + cookbookName + "'");
	
	File tmpDir = new File(System.getProperty("java.io.tmpdir"));
	chefTmpDir = new File(tmpDir, "uDeployChefSolo" + System.currentTimeMillis());
	
	System.out.println("chefTmpDir: " + chefTmpDir.canonicalFile);
	
	if (chefTmpDir.exists()) {
		chefTmpDir.deleteDir();
	}
	chefTmpDir.mkdir();

	System.out.println("Creating configuration file ");
	def soloFile = new File(chefTmpDir, "solo.rb");
	soloFile.withWriter { out ->
		out.writeLine("# Generated from uDeploy Chef plugin");
		out.writeLine("CHEF_DIR = File.expand_path(File.dirname(__FILE__))");
		out.writeLine("file_cache_path \"/tmp/chef-solo\"");
		out.writeLine("cookbook_path CHEF_DIR + \"/cookbooks\"");
	}
	
	def cookBooksDir = new File(chefTmpDir, "cookbooks");
	cookBooksDir.mkdir();
	def cookbookDir = new File(cookBooksDir, cookbookName);
	
	def workCookbooksDir = new File(workDir, "cookbooks/" + cookbookName);
	
	new AntBuilder().copy(todir: cookbookDir.canonicalPath) {
	    fileset(dir : workCookbooksDir.canonicalPath) { 
	        include(name:"**/*")
	        exclude(name:"**/*.git")
	    }
	}
	
	System.out.println("Creating attributes file.");
	if (!nodeJson || nodeJson.empty) {		
		nodeJson = String.format("{\"run_list\": [\"recipe[%s]\"]}", cookbookName);
	}
	
	def nodeFile = new File(chefTmpDir, "node.json");
	nodeFile.withWriter { out ->
		out.write(nodeJson);
	}
			
	def chefCmd = ["sh", "-c", "sudo chef-solo -N " + cookbookName + " -c solo.rb -j node.json"]	
	def cmdHelper = new CommandHelper(chefTmpDir);
	cmdHelper.runCommand("Executing chef-solo", chefCmd)	
}
finally {
	if (chefTmpDir != null && chefTmpDir.exists()) {
		chefTmpDir.deleteDir();
	}	
}