import com.urbancode.air.AirPluginTool
import java.util.Map


def apTool = new AirPluginTool(args[0], args[1])

try {

    def installFile = getInstallFile(apTool)
    def command = buildInstallCmd(installFile)
    
    // print out command info
    println("")
    println("command line: ${command}")
    println("working directory: ${workDir().path}")
    println('===============================')
    println("command output: ")
    
    //
    // Launch Process
    //
    final def processBuilder = new ProcessBuilder(command as String[]).directory(workDir())
    final def process = processBuilder.start()
    process.out.close() // close stdin
    process.waitForProcessOutput(System.out, System.err) // forward stdout and stderr
    process.waitFor()
    
    // print results
    println('===============================')
    println("command exit code: ${process.exitValue()}")
    println("")
	
    exitCode = process.exitValue();
    
    if( windows() ) {
        // this will return 'C:'
        def drive = System.getenv("SystemDrive");
        apTool.setOutputProperty("chefInstallDir", drive + File.separator + "opscode" + File.separator + "chef")
    } else {
        apTool.setOutputProperty("chefInstallDir", File.separator + "opt" + File.separator + "chef")
    }
    
    apTool.setOutputProperties();

	System.exit(exitCode);
}

catch (Exception e) {
	System.out.println("Error installing chef!");
	e.printStackTrace();
	System.exit(1);
}

def File homeDir() {
    def home = new File(System.getenv("PLUGIN_HOME"));
    if (!home.exists()) {
        throw new RuntimeException("Cannot get PLUGIN_HOME directory!");
    }
    
    return home
}

def File libDir() {
    def lib = new File(homeDir(), "lib");
    if (!lib.exists()) {
        throw new RuntimeException("Cannot get lib directory!");
    }
    
    return lib
}

def File workDir() {
    def work = new File('.').canonicalFile
    if (!work.exists()) {
        throw new RuntimeException("Cannot get working directory!");
    }
    
    return work
}

def String osName() {
    return System.getProperty('os.name').toLowerCase(Locale.US)
}

def boolean windows() {
    return (osName() =~ /windows/)
}

def File getInstallFile(AirPluginTool apTool) {
    
    def install = new File(libDir(), "chef-11.6.0-1.el6.x86_64.rpm")
    
    if( windows() ) {
        install = new File(libDir(), "chef-client-11.6.0-1.windows.msi")
    }
    
    return install
}

def String[] buildInstallCmd(File installFile) {
    
    def commandLine = [] 
    commandLine.add("rpm")
    commandLine.add("-ivh")
    
    if( windows() ) {
        commandLine = []
        commandLine.add("msiexec.exe")
        commandLine.add("/qb")
        commandLine.add("/i")
    }
    
    commandLine.add(installFile.absolutePath)
    return commandLine
}