/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;

public class ClearCaseUCMClient {
    private File viewLocation;
    private File exeFile;

    public ClearCaseUCMClient(File viewLocation, File exeFile) throws IOException {
        this.viewLocation = viewLocation;
        this.exeFile = exeFile;
    }

    public void update() throws IOException {
        List<String> command = Arrays.asList(this.exeFile.getAbsolutePath(), "update", ".");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.viewLocation);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            processes.discardOutput(process);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("ClearTool error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public String getLatestDate() throws IOException {
        String result = null;
        List<String> command = Arrays.asList(this.exeFile.getAbsolutePath(), "lshistory", "-nco", "-fmt", "\\n%Nd", "-r");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.viewLocation);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future errorFuture = processes.getErrorStringFuture(process);
            InputStreamReader reader = new InputStreamReader(process.getInputStream());
            BufferedReader bufReader = new BufferedReader(reader);
            result = "";
            while (result != null && result.equals("")) {
                String line = bufReader.readLine();
                if (line != null) {
                    result = line.trim();
                    continue;
                }
                result = null;
            }
            while (bufReader.readLine() != null) {
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("ClearTool error: " + (String)errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }
}

