/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PermissionViewMap {
    private final Map<Class<?>, Object> permissionViews;

    PermissionViewMap(Set<?> views) {
        if (views == null) {
            throw new NullPointerException("permissionViews");
        }
        if (views.contains(null)) {
            throw new IllegalArgumentException("permissionViews contains null");
        }
        HashMap map = new HashMap();
        for (Object view : views) {
            Class<?> viewClass = view.getClass();
            if (map.containsKey(viewClass)) {
                throw new IllegalArgumentException("multiple instances of the same view");
            }
            map.put(view.getClass(), view);
        }
        this.permissionViews = Collections.unmodifiableMap(map);
    }

    <T> T get(Class<T> viewClass) {
        if (viewClass == null) {
            throw new NullPointerException("viewClass");
        }
        return (T)this.permissionViews.get(viewClass);
    }

    Set<?> all() {
        return Collections.unmodifiableSet(new HashSet<Object>(this.permissionViews.values()));
    }
}

