/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.ClearCaseUCMClient;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws Exception {
        int returnCode = 0;
        try {
            List versions;
            boolean hasVersion;
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String componentName = this.inputProperties.getProperty("componentName");
            File vobLocation = new File(this.inputProperties.getProperty("viewLocation"));
            String[] includes = this.splitLines(this.inputProperties.getProperty("includes"));
            String[] excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
            boolean snapshotView = Boolean.valueOf(this.inputProperties.getProperty("snapshot"));
            File clearToolFile = new File(this.inputProperties.getProperty("path"));
            boolean saveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            if (includes.length == 0) {
                includes = new String[]{"**/*"};
            }
            String versionName = this.inputProperties.getProperty("versionName");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            ClearCaseUCMClient client = new ClearCaseUCMClient(vobLocation, clearToolFile);
            String finalVersionName = null;
            if (snapshotView) {
                client.update();
            }
            if (StringUtil.isEmpty(finalVersionName = client.getLatestDate())) {
                throw new Exception("Unable to find files to upload. Make sure the requested files are located in a View/Vob and added to source control (not view-private).");
            }
            if (!StringUtil.isEmpty(versionName)) {
                finalVersionName = versionName;
            }
            if (!(hasVersion = (versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false))).contains(finalVersionName))) {
                System.out.println(String.format("Creating version: %s", finalVersionName));
                String versionId = versionClient.createVersion(componentName, finalVersionName, " ", true).toString();
                this.outputProperties.setProperty("VersionID", versionId);
                if (isUseVFS) {
                    System.out.println("Uploading artifact files.");
                    versionClient.addVersionFiles(componentName, finalVersionName, vobLocation, "", includes, excludes, saveExecutePermissions, true, charset, extensions);
                } else {
                    System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                }
                versionClient.markImportFinished(componentName, versionId);
            } else {
                System.out.println(String.format("Component Already Has Version: %s", finalVersionName));
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            e.printStackTrace();
            returnCode = 1;
        }
        return returnCode;
    }

    private String[] splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        if (string != null) {
            BufferedReader in = IO.buffer(IO.reader(string));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }
}

