/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.concurrent.once.RunOnce;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ActionCountDownLatch
extends CountDownLatch {
    private final CountDownLatch onZeroActionLatch = new CountDownLatch(1);
    private final RunOnce onZeroActionOnce;

    public ActionCountDownLatch(int count, final Runnable onZeroAction) {
        super(count);
        Check.nonNull(onZeroAction, "onZeroAction");
        this.onZeroActionOnce = new RunOnce(){

            @Override
            protected void doRun() {
                try {
                    onZeroAction.run();
                }
                finally {
                    ActionCountDownLatch.this.onZeroActionLatch.countDown();
                }
            }
        };
    }

    @Override
    public void countDown() {
        super.countDown();
        if (this.getCount() == 0L) {
            this.onZeroActionOnce.run();
        }
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        this.onZeroActionLatch.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        boolean signalled = super.await(timeout, unit);
        if (signalled) {
            long waitTime = System.nanoTime() - startTime;
            long newTimeout = unit.toNanos(timeout) - waitTime;
            signalled = newTimeout > 0L ? this.onZeroActionLatch.await(newTimeout, TimeUnit.NANOSECONDS) : false;
        }
        return signalled;
    }
}

