/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.web.controller.DynamicResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ContentResponse
implements DynamicResponse {
    private String contentType;
    private String content;
    private String fileName;

    public ContentResponse(String content) {
        this("text/html", content);
    }

    public ContentResponse(String contentType, String content) {
        this.contentType = contentType;
        this.content = content;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.contentType);
        String encoding = response.getCharacterEncoding();
        byte[] data = this.content.getBytes(encoding);
        if (StringUtils.isNotEmpty((String)this.fileName)) {
            String header = "inline; filename=\"" + this.fileName.replaceAll("\"", "\\\\\"") + "\"";
            response.setHeader("Content-disposition", header);
        }
        response.setContentLength(data.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }
}

