/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.validation;

import com.urbancode.air.plugin.server.validation.PluginSchemaDocValidator;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.validation.PluginCommandPathValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public class PluginValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document validateAndTransform(ZipFile pluginZipFile) throws IOException, SchemaValidationException, XPathExpressionException, DOMException {
        Document pluginXmlDoc = null;
        InputStream pluginXmlInput = pluginZipFile.getInputStream(pluginZipFile.getEntry("plugin.xml"));
        try {
            pluginXmlDoc = new PluginSchemaDocValidator().validateAndTransform(pluginXmlInput);
            PluginCommandPathValidator commandPathValidator = new PluginCommandPathValidator(pluginZipFile);
            try {
                commandPathValidator.assertRelativeFilesExist(pluginXmlDoc, "//validation/@file", "validation");
                commandPathValidator.assertRelativeFilesExist(pluginXmlDoc, "//command/@file", "command");
                commandPathValidator.assertRelativeFilesExist(pluginXmlDoc, "//command/arg/@file", "argument");
                commandPathValidator.assertRelativePathFilesExist(pluginXmlDoc, "//command/arg/@path", "argument");
                commandPathValidator.assertRelativeFilesExist(pluginXmlDoc, "//env/@file", "environment");
                commandPathValidator.assertRelativePathFilesExist(pluginXmlDoc, "//env/@path", "environment");
            }
            catch (XPathExpressionException e) {
                throw new SchemaValidationException((Throwable)e);
            }
        }
        finally {
            pluginZipFile.close();
        }
        return pluginXmlDoc;
    }
}

