/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jPrintStream
extends PrintStream {
    private static final ThreadLocal<Boolean> inStream = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Logger logger;
    private Priority level;
    private ThreadLocal<StringBuffer> buffer = new ThreadLocal();

    public Log4jPrintStream(String loggerName, Priority level) {
        this(Logger.getLogger(loggerName), level);
    }

    public Log4jPrintStream(Logger logger, Priority level) {
        super(new ByteArrayOutputStream(0));
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void flush() {
        if (this.getBuffer().length() > 0) {
            this.println("");
        }
    }

    @Override
    public void print(String s) {
        this.getBuffer().append(s);
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(String s) {
        if (!inStream.get().booleanValue()) {
            inStream.set(true);
            try {
                this.getBuffer().append(s);
                this.logger.log(this.level, this.getBuffer().toString());
                this.resetBuffer();
            }
            finally {
                inStream.set(false);
            }
        }
    }

    @Override
    public void close() {
        this.logger = null;
    }

    @Override
    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.print(String.valueOf(c));
    }

    @Override
    public void print(char[] s) {
        this.print(new String(s));
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d));
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f));
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l));
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    @Override
    public void println(char c) {
        this.println(String.valueOf(c));
    }

    @Override
    public void println(char[] s) {
        this.println(String.valueOf(s));
    }

    @Override
    public void println(double d) {
        this.println(String.valueOf(d));
    }

    @Override
    public void println(float f) {
        this.println(String.valueOf(f));
    }

    @Override
    public void println(int i) {
        this.println(String.valueOf(i));
    }

    @Override
    public void println(long l) {
        this.println(String.valueOf(l));
    }

    @Override
    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.println(new String(buf, off, len));
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("method is not supported");
    }

    private StringBuffer getBuffer() {
        if (this.buffer.get() == null) {
            this.resetBuffer();
        }
        return this.buffer.get();
    }

    private void resetBuffer() {
        this.buffer.set(new StringBuffer());
    }
}

