/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.xml.marshall;

import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import com.urbancode.commons.xml.marshall.XMLHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXMLHelper<T>
implements XMLHelper<T> {
    public abstract String getObjectElementName();

    public abstract String getObjectCollectionElementName();

    @Override
    public T toObject(Document doc) {
        Element element = doc.getDocumentElement();
        if (!element.getNodeName().equals(this.getObjectElementName())) {
            throw new IllegalArgumentException("XML Document to unmarshal a object from document, must have a root element of " + this.getObjectElementName() + " and not " + element.getNodeName());
        }
        return this.toObject(element);
    }

    @Override
    public List<T> toObjectList(Element element) {
        if (!element.getNodeName().equals(this.getObjectCollectionElementName())) {
            throw new IllegalArgumentException("XML Document to unmarshal object array from element, must have a root element of " + this.getObjectCollectionElementName() + " and not " + element.getNodeName());
        }
        ArrayList list = new ArrayList();
        for (Element childElement : DOMUtils.getChildElementArray(element, this.getObjectElementName())) {
            Object child = this.toObject(childElement);
            if (child == null) continue;
            list.add(child);
        }
        return list;
    }

    @Override
    public List<T> toObjectList(Document doc) {
        Element docElement = doc.getDocumentElement();
        if (!docElement.getNodeName().equals(this.getObjectCollectionElementName())) {
            throw new IllegalArgumentException("XML Document to unmarshal object array from document, must have a root element of " + this.getObjectCollectionElementName() + " and not " + docElement.getNodeName());
        }
        ArrayList list = new ArrayList();
        for (Element element : DOMUtils.getChildElementArray(docElement, this.getObjectElementName())) {
            Object object = this.toObject(element);
            if (object == null) continue;
            list.add(object);
        }
        return list;
    }

    @Override
    public Document toXML(T object) throws ParserConfigurationException {
        DocumentBuilderFactoryBuilder dbfb = DocumentBuilderFactoryBuilder.newBuilder();
        DocumentBuilderFactory factory = dbfb.newDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element docElement = this.toXML(object, doc);
        doc.appendChild(docElement);
        return doc;
    }

    @Override
    public Document toXML(T[] array) throws ParserConfigurationException {
        DocumentBuilderFactoryBuilder dbfb = DocumentBuilderFactoryBuilder.newBuilder();
        DocumentBuilderFactory factory = dbfb.newDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element docElement = this.toXML(array, doc);
        doc.appendChild(docElement);
        return doc;
    }

    @Override
    public Element toXML(T[] array, Document doc) {
        Element element = doc.createElement(this.getObjectCollectionElementName());
        for (T object : array) {
            Element childElement = this.toXML(object, doc);
            element.appendChild(childElement);
        }
        return element;
    }

    protected Element createTextElement(Document doc, String name, String value) {
        Element element = doc.createElement(name);
        if (value != null) {
            char[] chars = value.toCharArray();
            boolean escape = false;
            for (int i = 0; i < chars.length && !escape; ++i) {
                char c = chars[i];
                escape = c == '<' || c == '>' || c == '\'' || c == '\"' || c == '&';
            }
            if (escape) {
                element.appendChild(doc.createCDATASection(value));
            } else {
                element.appendChild(doc.createTextNode(value));
            }
        }
        return element;
    }
}

