/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.concurrent;

import com.urbancode.commons.util.ExceptionSupport;
import com.urbancode.concurrent.AtomicStartSupport;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

@Deprecated
public abstract class ServiceThread
extends Thread {
    private AtomicStartSupport atomicStartSupport = new AtomicStartSupport();
    private ExceptionSupport exceptionSupport = new ExceptionSupport();
    private CountDownLatch shutdownLatch;
    private Logger logger;

    public ServiceThread(String theName) {
        super(theName);
    }

    public void setShutdownLatch(CountDownLatch shutdownLatch) {
        this.getAtomicStartSupport().assertNotStarted();
        this.shutdownLatch = shutdownLatch;
    }

    @Override
    public void start() {
        this.getAtomicStartSupport().assertNotStartedAndSetStarted();
        this.validateAtStart();
        this.prestart();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExceptionSupport support = this.getExceptionSupport();
        Logger log = this.getLogger();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Starting thread " + this.getName());
            }
            this.call();
        }
        catch (Throwable t) {
            if (!support.isRootCauseInterruption(t)) {
                support.logError(log, "Failure in thread " + this.getName(), t);
            }
        }
        finally {
            this.getShutdownLatch().countDown();
            if (log.isDebugEnabled()) {
                log.debug("Thread " + this.getName() + " shutdown complete");
            }
        }
    }

    protected abstract void call() throws Exception;

    protected void prestart() {
    }

    public boolean isStarted() {
        return this.getAtomicStartSupport().isStarted();
    }

    public void sleepFor(long aLong) throws InterruptedException {
        if (Thread.currentThread() != this) {
            throw new IllegalStateException("invalid thread");
        }
        Thread.sleep(aLong);
    }

    protected void validateAtStart() {
        if (this.getShutdownLatch() == null) {
            throw new IllegalStateException("shutdownLatch not set");
        }
    }

    protected CountDownLatch getShutdownLatch() {
        return this.shutdownLatch;
    }

    protected synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass());
        }
        return this.logger;
    }

    protected synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected AtomicStartSupport getAtomicStartSupport() {
        return this.atomicStartSupport;
    }

    protected void setAtomicStartSupport(AtomicStartSupport atomicStartSupport) {
        this.atomicStartSupport = atomicStartSupport;
    }

    protected void setExceptionSupport(ExceptionSupport exceptionSupport) {
        this.exceptionSupport = exceptionSupport;
    }

    protected ExceptionSupport getExceptionSupport() {
        return this.exceptionSupport;
    }
}

