/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.PRF;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

class Keys {
    private final SecretContainer secret;
    private final byte[] iv;
    private final long timestamp;
    private final CryptoSuite cryptoSuite;
    private SecretKey macKey;
    private SecretKey cipherKey;

    Keys(SecretContainer secret, byte[] iv, long timestamp, CryptoSuite cryptoSuite) {
        secret.getClass();
        iv.getClass();
        cryptoSuite.getClass();
        this.secret = secret;
        this.iv = iv;
        this.timestamp = timestamp;
        this.cryptoSuite = cryptoSuite;
    }

    SecretKey getMACKey() throws GeneralSecurityException {
        this.computeKeys();
        return this.macKey;
    }

    SecretKey getCipherKey() throws GeneralSecurityException {
        this.computeKeys();
        return this.cipherKey;
    }

    private synchronized void computeKeys() throws GeneralSecurityException {
        if (this.macKey == null || this.cipherKey == null) {
            MACAlgorithm macAlgorithm = this.cryptoSuite.getMACAlgorithm();
            CipherAlgorithm cipherAlgorithm = this.cryptoSuite.getCipherAlgorithm();
            PRF prf = new PRF(this.secret, "key expansion " + this.timestamp, this.iv, macAlgorithm);
            byte[] hmacKeyData = new byte[macAlgorithm.getKeyLength()];
            byte[] encryptionKeyData = new byte[cipherAlgorithm.getKeyLength()];
            byte[] keyData = prf.getBytes(hmacKeyData.length + encryptionKeyData.length);
            System.arraycopy(keyData, 0, hmacKeyData, 0, hmacKeyData.length);
            System.arraycopy(keyData, hmacKeyData.length, encryptionKeyData, 0, encryptionKeyData.length);
            this.macKey = macAlgorithm.createKey(hmacKeyData);
            this.cipherKey = cipherAlgorithm.createKey(encryptionKeyData);
        }
    }
}

