/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.nonull.NonNull;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

final class NonNullSortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final SortedSet<E> delegate;

    NonNullSortedSet(SortedSet<E> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public boolean add(E element) {
        Check.nonNull(element, "element");
        return this.delegate.add(element);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate.comparator();
    }

    @Override
    public E first() {
        return this.delegate.first();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new NonNullSortedSet<E>(this.delegate.headSet(toElement));
    }

    @Override
    public E last() {
        return this.delegate.last();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return new NonNullSortedSet<E>(this.delegate.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new NonNullSortedSet<E>(this.delegate.tailSet(fromElement));
    }
}

