/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class Paths {
    private static final String PLATFORM_SEPARATOR = System.getProperty("com.urbancode.commons.util.Paths.platformSeparator", File.separator);
    private static final String PLATFORM_SEPARATOR_CHAR = System.getProperty("com.urbancode.commons.util.Paths.platformSeparatorChar", String.valueOf(File.separatorChar));
    static final Set<String> WINDOWS_DEVICE_FILES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private static String platformSeparator = PLATFORM_SEPARATOR;
    private static char platformSeparatorChar = PLATFORM_SEPARATOR_CHAR.charAt(0);

    static String getPlatformSeparator() {
        return platformSeparator;
    }

    static char getPlatformSeparatorChar() {
        return platformSeparatorChar;
    }

    static void setPlatformSeparator(String value) {
        platformSeparator = value;
    }

    static void setPlatformSeparatorChar(char value) {
        platformSeparatorChar = value;
    }

    private static boolean isWindows() {
        return platformSeparatorChar == '\\';
    }

    public static String cleanSeparators(String path) {
        return path.replace('\\', '/').replaceAll("/+", "/");
    }

    @Deprecated
    public static boolean isSafe(String path) {
        return Paths.isRelative(path) && !path.startsWith("../") && !path.endsWith("/..") && !path.contains("/../") && !path.equals("..");
    }

    public static boolean isRelative(String path) {
        return !Paths.isAbsoluteUnix(path) && !Paths.isAbsoluteWindows(path);
    }

    public static boolean isAbsoluteUnix(String path) {
        return path.length() > 0 && path.charAt(0) == '/';
    }

    public static boolean isAbsoluteWindows(String path) {
        boolean result = false;
        if (path.length() > 2) {
            char c0 = path.charAt(0);
            char c1 = path.charAt(1);
            char c2 = path.charAt(2);
            result = (c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') && c1 == ':' && Paths.isSlash(c2) || Paths.isSlash(c0) && Paths.isSlash(c1);
        }
        return result;
    }

    public static boolean isPathSafe(String path) {
        if ((path = path.replace('\\', '/').trim()).equals("..") || path.startsWith("../") || path.contains("/../") || path.endsWith("/..")) {
            return false;
        }
        if (path.startsWith("/")) {
            return false;
        }
        if (Paths.isWindows()) {
            if (Paths.isWindowsDeviceFile(path)) {
                return false;
            }
            if (path.contains(":")) {
                return false;
            }
            int start = 0;
            while (start < path.length()) {
                String name;
                int end = path.indexOf(47, start);
                if (end == -1) {
                    end = path.length();
                }
                if ((name = path.substring(start, end)).endsWith(".") && !name.equals(".")) {
                    return false;
                }
                start = end + 1;
            }
        }
        return true;
    }

    public static String forceRelativePath(String path) {
        return Paths.fixPlatformSeparator(Paths.cleanSeparators("./" + path));
    }

    public static boolean isWindowsDeviceFile(String path) {
        if ((path = Paths.fixPlatformSeparator(path).toUpperCase(Locale.US).trim()).startsWith(platformSeparator + platformSeparator + "." + platformSeparator)) {
            return true;
        }
        int start = 0;
        while (start < path.length()) {
            String name;
            int dot;
            int end = path.indexOf(platformSeparator, start);
            if (end == -1) {
                end = path.length();
            }
            if ((dot = (name = path.substring(start, end)).indexOf(46)) != -1) {
                name = name.substring(0, dot);
            }
            if (WINDOWS_DEVICE_FILES.contains(name)) {
                return true;
            }
            start = end + 1;
        }
        return false;
    }

    static String fixPlatformSeparator(String path) {
        path = platformSeparatorChar == '/' ? path.replace('\\', platformSeparatorChar) : path.replace('/', platformSeparatorChar);
        return path;
    }

    private static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private Paths() {
        throw new IllegalArgumentException();
    }
}

