/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;

public class HttpClientPackage {
    private final CloseableHttpClient client;
    private final HttpClientConnectionManager connectionManager;
    private final CredentialsProvider credentialsProvider;

    protected HttpClientPackage(CloseableHttpClient client, HttpClientConnectionManager connectionManager, CredentialsProvider credentialsProvider) {
        this.client = client;
        this.client.getClass();
        this.connectionManager = connectionManager;
        this.connectionManager.getClass();
        this.credentialsProvider = credentialsProvider;
        this.credentialsProvider.getClass();
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public PoolStats getPoolStats(HttpRoute route) {
        PoolingHttpClientConnectionManager pool = this.getPool();
        if (pool == null) {
            return null;
        }
        return pool.getStats(route);
    }

    public PoolStats getTotalPoolStats() {
        PoolingHttpClientConnectionManager pool = this.getPool();
        if (pool == null) {
            return null;
        }
        return pool.getTotalStats();
    }

    protected PoolingHttpClientConnectionManager getPool() {
        HttpClientConnectionManager cm = this.getConnectionManager();
        if (cm instanceof PoolingHttpClientConnectionManager) {
            return (PoolingHttpClientConnectionManager)cm;
        }
        return null;
    }
}

