/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.ds.client.ConsoleSize;
import com.urbancode.ds.client.HelpUtil;
import org.w3c.dom.Element;

public class ClientCommandOption {
    private final String name;
    private final String shortName;
    private final String envName;
    private final String description;
    private final boolean required;
    private final String defaultValue;
    private final ParamType paramType;

    public static ClientCommandOption fromXML(Element element) {
        String name = element.getAttribute("name");
        String requiredString = element.getAttribute("required");
        boolean required = Boolean.valueOf(requiredString);
        String defaultValue = element.getAttribute("default");
        if (defaultValue.length() == 0) {
            defaultValue = null;
        }
        String description = null;
        String environmentName = null;
        Element docElement = DOMUtils.getFirstChild(element, "doc");
        if (docElement != null) {
            Element environmentNameElement;
            Element descriptionElement = DOMUtils.getFirstChild(docElement, "description");
            if (descriptionElement != null) {
                description = descriptionElement.getTextContent();
            }
            if ((environmentNameElement = DOMUtils.getFirstChild(docElement, "environmentName")) != null) {
                environmentName = environmentNameElement.getTextContent();
            }
        }
        ParamType paramType = ParamType.PATH;
        String style = element.getAttribute("style");
        if ("query".equals(style)) {
            paramType = ParamType.QUERY;
        }
        ClientCommandOption option = new ClientCommandOption(name, name, environmentName, description, required, defaultValue, paramType);
        return option;
    }

    public ClientCommandOption(String name, String shortName, String envName, String description, boolean required, String defaultValue, ParamType paramType) {
        this.name = name;
        this.shortName = shortName;
        this.envName = envName;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.paramType = paramType;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ParamType getParamType() {
        return this.paramType;
    }

    public String toHelp() {
        String LS = System.getProperty("line.separator");
        int columns = new ConsoleSize().getColumns();
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        if (!StringUtil.isEmpty(this.getShortName())) {
            sb.append(" -").append(this.getShortName()).append(",");
        }
        sb.append(" --").append(this.getName()).append(LS);
        sb.append("            ");
        StringBuilder descBuilder = new StringBuilder();
        if (this.isRequired()) {
            descBuilder.append("Required. ");
        } else {
            descBuilder.append("Optional. ");
        }
        if (this.getEnvName() != null) {
            descBuilder.append("Can be set via the environment variable " + this.getEnvName() + ". ");
        }
        descBuilder.append(this.getDescription());
        if (this.getDefaultValue() != null) {
            descBuilder.append(" (Default Value: " + this.getDefaultValue() + ")");
        }
        HelpUtil.manageLineWrapping(sb, descBuilder.toString(), 12, columns);
        return sb.toString();
    }

    public static enum ParamType {
        QUERY,
        PATH;

    }
}

