/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ds.client.ConsoleSize;
import com.urbancode.ds.client.HelpUtil;

public class ClientCommandFlag {
    private final String name;
    private final String shortName;
    private final String description;

    public ClientCommandFlag(String name, String shortName, String description) {
        this.name = name;
        this.shortName = shortName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toHelp() {
        String LS = System.getProperty("line.separator");
        int columns = new ConsoleSize().getColumns();
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        if (!StringUtil.isEmpty(this.getShortName())) {
            sb.append(" -").append(this.getShortName()).append(",");
        }
        sb.append(" --").append(this.getName()).append(LS);
        sb.append("            ");
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append(this.getDescription());
        HelpUtil.manageLineWrapping(sb, descBuilder.toString(), 12, columns);
        return sb.toString();
    }
}

