/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import com.urbancode.commons.web.util.ListeningInfo;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppContainerUtil {
    private static final Logger log = Logger.getLogger(WebAppContainerUtil.class);

    public Set<ListeningInfo> getListeningInfo(ServletContext context) throws MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, URISyntaxException, UnknownHostException {
        LinkedHashSet<ListeningInfo> result = new LinkedHashSet<ListeningInfo>();
        MBeanServer server = null;
        ArrayList<MBeanServer> serverList = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer mBeanServer : serverList) {
            String domain = mBeanServer.getDefaultDomain();
            if (domain.equalsIgnoreCase("Catalina")) {
                server = mBeanServer;
                break;
            }
            if (server != null) continue;
            server = mBeanServer;
        }
        if (server == null) {
            log.warn("Could not locate " + MBeanServer.class.getSimpleName());
            return Collections.emptySet();
        }
        ObjectName name = new ObjectName("Catalina:*,type=Connector");
        Set<ObjectName> names = server.queryNames(name, null);
        for (ObjectName on : names) {
            String host;
            String protocol = (String)server.getAttribute(on, "protocol");
            Object address = server.getAttribute(on, "address");
            boolean isAnyAddress = false;
            String sslProtocol = (String)server.getAttribute(on, "sslProtocol");
            Integer portInteger = (Integer)server.getAttribute(on, "port");
            Boolean secure = (Boolean)server.getAttribute(on, "secure");
            String scheme = StringUtils.containsIgnoreCase(protocol, "http") ? (secure.booleanValue() ? "https" : "http") : (StringUtils.containsIgnoreCase(protocol, "ajp") ? "ajp" : "unknown");
            if (address == null) {
                isAnyAddress = true;
                host = InetAddress.getLocalHost().getHostName();
            } else if (address instanceof InetAddress) {
                InetAddress inetAddress = (InetAddress)address;
                if (inetAddress.isAnyLocalAddress()) {
                    isAnyAddress = true;
                    inetAddress = InetAddress.getLocalHost();
                }
                host = inetAddress.getHostName();
            } else {
                host = String.valueOf(address);
            }
            int port = portInteger;
            if ("http".equals(scheme) && port == 80) {
                port = -1;
            } else if ("https".equals(scheme) && port == 443) {
                port = -1;
            }
            HashSet<String> contextPathSet = new HashSet<String>();
            Set<ObjectName> nameSet = server.queryNames(new ObjectName("Catalina:type=Valve,*"), null);
            for (ObjectName valve : nameSet) {
                String contextPath;
                String path = valve.getKeyProperty("path");
                if (StringUtils.isNotEmpty(path)) {
                    contextPathSet.add(path);
                }
                if (!StringUtils.isNotEmpty(contextPath = valve.getKeyProperty("context"))) continue;
                contextPathSet.add(contextPath);
            }
            for (String contextPath : contextPathSet) {
                URI uri = new URI(scheme, null, host, port, contextPath, null, null);
                ListeningInfo info = new ListeningInfo(isAnyAddress, uri, secure != false ? sslProtocol : null);
                result.add(info);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<URI> getListeningAddresses(ServletContext context) throws Exception {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (ListeningInfo info : this.getListeningInfo(context)) {
            result.add(info.getUri());
        }
        return Collections.unmodifiableSet(result);
    }
}

