/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentClient
extends UDRestClient {
    public ComponentClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public ComponentClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public void addComponentVersionLink(String componentName, String versionName, String linkTitle, String linkURL) throws JSONException, IOException {
        String uri = this.url + "/cli/version/addLink?component=" + this.encodePath(componentName) + "&version=" + this.encodePath(versionName) + "&linkName=" + this.encodePath(linkTitle) + "&link=" + this.encodePath(linkURL);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public void addComponentVersionStatus(String componentName, String versionName, String statusName) throws IOException {
        String uri = this.url + "/cli/version/addStatus?component=" + this.encodePath(componentName) + "&version=" + this.encodePath(versionName) + "&status=" + this.encodePath(statusName);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public void addComponentToTeam(String component, String team, String type) throws IOException {
        String uri = this.url + "/cli/component/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&component=" + this.encodePath(component);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public String addTagToComponent(String componentName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/component/tag?component=" + this.encodePath(componentName) + "&tag=" + this.encodePath(tagName);
        HttpPut method = new HttpPut(uri);
        HttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    public UUID createComponent(String componentName, String description, String sourceConfigPlugin, String defaultVersionType, String templateName, int templateVersion, boolean importAutomatically, boolean useVfs) throws JSONException, IOException {
        return this.createComponent(componentName, description, sourceConfigPlugin, defaultVersionType, templateName, templateVersion, importAutomatically, useVfs, null);
    }

    public UUID createComponent(String componentName, String description, String sourceConfigPlugin, String defaultVersionType, String templateName, int templateVersion, boolean importAutomatically, boolean useVfs, Map<String, String> properties) throws JSONException, IOException {
        UUID result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", componentName);
        jsonToSend.put("sourceConfigPlugin", sourceConfigPlugin);
        jsonToSend.put("defaultVersionType", defaultVersionType.toUpperCase());
        jsonToSend.put("importAutomatically", importAutomatically);
        jsonToSend.put("useVfs", useVfs);
        if (!"".equals(description) && description != null) {
            jsonToSend.put("description", description);
        }
        if (!"".equals(templateName) && templateName != null) {
            jsonToSend.put("templateName", templateName);
        }
        if (templateVersion > 0) {
            jsonToSend.put("templateVersion", templateVersion);
        }
        JSONObject propertiesObject = new JSONObject();
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, String> ent : properties.entrySet()) {
                propertiesObject.put(ent.getKey(), ent.getValue());
            }
        }
        jsonToSend.put("properties", propertiesObject);
        String uri = this.url + "/cli/component/create";
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(jsonToSend));
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    public UUID deleteComponent(String componentName) throws IOException, JSONException {
        UUID compUUID = this.getComponentUUID(componentName);
        String uri = this.url + "/rest/deploy/component/" + compUUID.toString();
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
        return compUUID;
    }

    public JSONArray getComponentApplications(String componentName) throws IOException, JSONException {
        JSONArray result = null;
        UUID compUUID = this.getComponentUUID(componentName);
        String uri = this.url + "/rest/deploy/component/" + compUUID.toString() + "/applications";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public void createComponentVersion(String version, String component) throws IOException {
        String uri = this.url + "/cli/version/createVersion?name=" + this.encodePath(version) + "&component=" + this.encodePath(component);
        HttpPost method = new HttpPost(uri);
        HttpResponse response = this.invokeMethod(method);
        EntityUtils.consume(response.getEntity());
    }

    public Map<String, String> getComponentProperties(String component) throws IOException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        String uri = this.url + "/cli/component/getProperties?component=" + this.encodePath(component);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject propObject = (JSONObject)propsJSON.get(i);
            result.put((String)propObject.get("name"), (String)propObject.get("value"));
        }
        return result;
    }

    public JSONArray getComponentProcessRequestProperties(String processId) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/deploy/componentProcessRequest/" + this.encodePath(processId) + "/properties";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        JSONObject props = new JSONObject(this.getBody(response));
        result = props.getJSONArray("properties");
        return result;
    }

    public UUID getComponentUUID(String component) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/component/info?component=" + this.encodePath(component);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject resultJSON = new JSONObject(body);
        result = UUID.fromString(resultJSON.getString("id"));
        return result;
    }

    public JSONObject getComponent(String component) throws IOException, JSONException {
        String uri = this.url + "/cli/component/info?component=" + this.encodePath(component);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        return new JSONObject(body);
    }

    public void removeComponentVersionStatus(String componentName, String versionName, String statusName) throws IOException {
        String uri = this.url + "/cli/version/status?component=" + this.encodePath(componentName) + "&version=" + this.encodePath(versionName) + "&status=" + this.encodePath(statusName);
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
    }

    public String removeTagFromComponent(String componentName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/component/tag?component=" + this.encodePath(componentName) + "&tag=" + this.encodePath(tagName);
        HttpDelete method = new HttpDelete(uri);
        HttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    public void setComponentProcessRequestProperty(String processId, String name, String value, boolean isSecure) throws IOException, JSONException {
        if (StringUtils.isEmpty(processId)) {
            throw new IOException("processId was not supplied");
        }
        if (StringUtils.isEmpty(name)) {
            throw new IOException("name was not supplied");
        }
        String uri = this.url + "/rest/deploy/componentProcessRequest/" + this.encodePath(processId) + "/saveProperties";
        JSONArray props = new JSONArray();
        props.put(this.createNewPropertyJSON(name, value, isSecure));
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(props));
        this.invokeMethod(method);
    }

    public String setComponentProperty(String componentName, String name, String value, boolean isSecure) throws IOException {
        String result = null;
        if ("".equals(componentName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/component/propValue?component=" + this.encodePath(componentName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public void updateSourceConfigProperty(String componentParam, String name, String value, String description, Boolean secure) throws IOException, JSONException {
        JSONObject propJson = this.createNewPropertyJSON(name, value, secure);
        propJson.put("description", description);
        String uri = this.url + "/rest/deploy/component/" + this.encodePath(componentParam) + "/updateSourceConfigProperties/" + this.encodePath(name);
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(propJson));
        this.invokeMethod(method);
    }

    public List<String> getComponentVersions(String componentParam, Boolean getInactive) throws ClientProtocolException, IOException, JSONException {
        ArrayList<String> result = new ArrayList<String>();
        String uri = this.url + "/rest/deploy/component/" + this.encodePath(componentParam) + "/versions/" + this.encodePath(getInactive.toString());
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray resultJSON = new JSONArray(body);
        for (int i = 0; i < resultJSON.length(); ++i) {
            JSONObject entry = resultJSON.getJSONObject(i);
            result.add(entry.getString("name"));
        }
        return result;
    }

    public List<String> getArchivedComponentVersions(String componentParam) throws ClientProtocolException, IOException, JSONException {
        ArrayList<String> result = new ArrayList<String>();
        String uri = this.url + "/rest/deploy/component/" + this.encodePath(componentParam) + "/versions/true?filterFields=archived&filterValue_archived=true&filterType_archived=eq&filterClass_archived=Boolean";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray resultJSON = new JSONArray(body);
        for (int i = 0; i < resultJSON.length(); ++i) {
            JSONObject entry = resultJSON.getJSONObject(i);
            result.add(entry.getString("name"));
        }
        return result;
    }

    public String getLatestVersion(String componentParam) throws ClientProtocolException, IOException, JSONException {
        String result = null;
        String uri = this.url + "/rest/deploy/component/" + this.encodePath(componentParam) + "/latestVersion";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        if (body != null) {
            JSONObject resultJSON = new JSONObject(body);
            result = resultJSON.getString("name");
        }
        return result;
    }
}

