/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.vfs.common.ClientObject;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClientRepository
implements ClientObject {
    protected final String repositoryId;
    protected final String latestChangeSet;

    public static ClientRepository fromJSON(JSONObject json) throws JSONException {
        String repositoryId = json.getString("repoId");
        String latestChangeSet = null;
        if (json.has("latestChangeSet")) {
            latestChangeSet = json.getString("latestChangeSet");
        }
        return new ClientRepository(repositoryId, latestChangeSet);
    }

    protected ClientRepository(String repositoryId, String latestChangeSet) {
        this.repositoryId = repositoryId;
        this.latestChangeSet = latestChangeSet;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getLatestChangeSet() {
        return this.latestChangeSet;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("repoId", this.getRepositoryId());
        String latestChangeSet = this.getLatestChangeSet();
        if (latestChangeSet != null) {
            json.put("latestChangeSet", latestChangeSet);
        }
        return json;
    }
}

