/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cocking.anttasks;

import java.io.FileNotFoundException;
import java.io.FileReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import uk.co.cocking.anttasks.XPathEvaluator;
import uk.co.cocking.anttasks.XPathEvaluatorException;
import uk.co.cocking.anttasks.XomXPathEvaluator;

public class XPathTask
extends Task {
    private String outputProperty = "output";
    private String document;
    private String xpath;
    private XPathEvaluator evaluator;
    private String delimiter = " ";

    public XPathTask() {
        this(new XomXPathEvaluator());
    }

    public XPathTask(XPathEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void execute() throws BuildException {
        this.checkWeSet(this.xpath, "xpath");
        this.checkWeSet(this.document, "document");
        try {
            this.setProperty(this.outputProperty, this.collect(this.evaluator.evaluate(this.xpath, new FileReader(this.document))));
        }
        catch (XPathEvaluatorException e) {
            throw new BuildException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("could not find file " + this.document, (Throwable)e);
        }
    }

    private String collect(String[] values) {
        String result = "";
        for (String value : values) {
            result = result + value + this.delimiter;
        }
        result = result.substring(0, result.length() - this.delimiter.length());
        return result;
    }

    private void checkWeSet(String argument, String name) {
        if (argument == null) {
            throw new BuildException(name + " is required but has not been set");
        }
    }

    private void setProperty(String name, String value) {
        this.getProject().setProperty(name, value);
    }

    public void setOutputProperty(String outputProperty) {
        this.log("Setting the output property: " + outputProperty, 3);
        this.outputProperty = outputProperty;
    }

    public void setDocument(String document) {
        this.log("evaluating in document: " + document, 3);
        this.document = document;
    }

    public void setXpath(String xpath) {
        this.log("evaluating xpath: " + xpath, 3);
        this.xpath = xpath;
    }
}

