/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.ssl.ClientAuthMode;
import java.io.IOException;
import java.net.InetAddress;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

@BridgeMethodsAdded
public class ClientAuthSSLServerSocketFactory
extends SSLServerSocketFactory {
    private final SSLServerSocketFactory delegate;
    private final ClientAuthMode authenticationMode;

    public ClientAuthSSLServerSocketFactory(SSLServerSocketFactory delegate) {
        this(delegate, ClientAuthMode.REQUIRED);
    }

    public ClientAuthSSLServerSocketFactory(SSLServerSocketFactory delegate, ClientAuthMode authenticationMode) {
        this.delegate = Check.nonNull(delegate, "delegate");
        this.authenticationMode = Check.nonNull(authenticationMode, "authenticationMode");
    }

    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    public SSLServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port);
        this.authenticationMode.configure(socket);
        return socket;
    }

    public SSLServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog);
        this.authenticationMode.configure(socket);
        return socket;
    }

    public SSLServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.delegate.createServerSocket(port, backlog, ifAddress);
        this.authenticationMode.configure(socket);
        return socket;
    }
}

