/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter.csrf;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.filter.csrf.Whitelist;
import com.urbancode.commons.web.filter.csrf.WhitelistBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CsrfFilter
implements Filter {
    private static final Logger log = Logger.getLogger(CsrfFilter.class);
    private static final boolean disabled = Boolean.getBoolean("com.urbancode.commons.web.filter.csrf.CsrfFilter.disabled") || Boolean.getBoolean("com.urbancode.anthill3.web.csrf.CsrfFilter.disabled") || Boolean.getBoolean("com.urbancode.ubuild.web.csrf.CsrfFilter.disabled");
    public static final String ALLOWED_ORIGIN_PROP = "com.urbancode.commons.web.filter.csrf.CsrfFilter.allowedOrigins";
    private static final List<URL> allowedOrigins;
    Whitelist whitelist;
    String csrfErrorPage;

    public void init(FilterConfig config) throws ServletException {
        if (!disabled) {
            this.csrfErrorPage = config.getInitParameter("errorPage");
            if (this.csrfErrorPage == null) {
                throw new ServletException("CSRF filter init: no errorPage specified");
            }
            this.csrfErrorPage = this.csrfErrorPage.trim();
            if (this.csrfErrorPage.isEmpty()) {
                throw new ServletException("CSRF filter init: empty errorPage specified");
            }
            String whitelistStr = config.getInitParameter("whitelist");
            if (whitelistStr == null) {
                throw new ServletException("CSRF filter init: no whitelist");
            }
            WhitelistBuilder builder = new WhitelistBuilder();
            try {
                this.whitelist = builder.build(IO.buffer(IO.reader(whitelistStr)));
            }
            catch (IOException e) {
                throw new ServletException("CSRF filter init: invalid whitelist", (Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean accepted = true;
        if (!disabled && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String path = httpRequest.getRequestURI();
            String referer = httpRequest.getHeader("Referer");
            boolean proxied = false;
            String proxyHost = null;
            accepted = this.whitelist.isAccepted(path);
            if (!accepted && referer != null) {
                String requestUrl = httpRequest.getRequestURL().toString();
                String forwardHost = httpRequest.getHeader("X-Forwarded-Host");
                String forwardProto = httpRequest.getHeader("X-Forwarded-Proto");
                String forwardPort = httpRequest.getHeader("X-Forwarded-Port");
                proxied = StringUtils.isNotBlank(forwardHost);
                if (proxied) {
                    proxyHost = httpRequest.getRemoteHost();
                }
                accepted = this.isAcceptable(requestUrl, referer, forwardHost, forwardProto, forwardPort);
            }
            if (!accepted) {
                log.warn(String.format("Possible CSRF attack:%n  path=%s%n  referer=%s%n  proxied=%s%n  proxy-source=%s", path, StringUtils.defaultIfBlank(referer, "none"), proxied, StringUtils.defaultIfBlank(proxyHost, "none")));
                StringBuilder uri = new StringBuilder();
                uri.append(request.getScheme());
                uri.append("://");
                uri.append(request.getServerName());
                uri.append(":");
                uri.append(httpRequest.getServerPort());
                String baseUri = uri.toString() + httpRequest.getContextPath();
                uri.append(httpRequest.getRequestURI());
                if (StringUtils.isNotEmpty(httpRequest.getQueryString())) {
                    uri.append("?");
                    uri.append(httpRequest.getQueryString());
                }
                request.setAttribute("baseUri", (Object)baseUri);
                request.setAttribute("requestedUri", (Object)uri.toString());
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(403, "Possible CSRF attack");
                request.getRequestDispatcher(this.csrfErrorPage).forward(request, response);
            }
        }
        if (accepted) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    boolean isAcceptable(String request, String referer, String forwardHost, String forwardProto, String forwardPort) {
        boolean accepted;
        block9: {
            try {
                URL refererUrl = new URL(referer);
                URL requestUrl = new URL(request);
                if (StringUtils.isNotEmpty(forwardHost)) {
                    if (forwardProto == null) {
                        forwardProto = refererUrl.getProtocol();
                    }
                    int refererPort = refererUrl.getPort();
                    if (forwardPort != null) {
                        try {
                            refererPort = Integer.valueOf(forwardPort);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    requestUrl = this.replaceOrigin(requestUrl, forwardProto, forwardHost, refererPort);
                }
                if (accepted = this.isSameOrigin(requestUrl, refererUrl)) break block9;
                for (URL allowedOrigin : allowedOrigins) {
                    if (!accepted) {
                        accepted = this.isSameOrigin(allowedOrigin, refererUrl);
                        continue;
                    }
                    break;
                }
            }
            catch (MalformedURLException e) {
                log.error("Unable to parse request or referer URLs", e);
                accepted = false;
            }
        }
        return accepted;
    }

    boolean isSameOrigin(URL x, URL y) {
        String xScheme = this.toLowerCase(x.getProtocol());
        String xHost = this.toLowerCase(x.getHost());
        int xPort = this.getPort(x);
        String yScheme = this.toLowerCase(y.getProtocol());
        String yHost = this.toLowerCase(y.getHost());
        int yPort = this.getPort(y);
        return this.equals(xScheme, yScheme) && this.equals(xHost, yHost) && xPort == yPort;
    }

    private String toLowerCase(String s) {
        return s == null ? s : s.toLowerCase(Locale.US);
    }

    private boolean equals(Object x, Object y) {
        return x == y || x != null && x.equals(y);
    }

    private int getPort(URL u) {
        int result = u.getPort();
        if (result == -1) {
            String scheme = this.toLowerCase(u.getProtocol());
            result = "http".equals(scheme) ? 80 : ("https".equals(scheme) ? 443 : u.getDefaultPort());
        }
        return result;
    }

    private URL replaceOrigin(URL u, String protocol, String host, int port) throws MalformedURLException {
        if (protocol == null) {
            protocol = u.getProtocol();
        }
        if (port == -1) {
            port = u.getPort();
        }
        return new URL(protocol, host, port, u.getPath());
    }

    static {
        String allowedOriginProp = System.getProperty(ALLOWED_ORIGIN_PROP);
        ArrayList<URL> allowedOriginList = new ArrayList<URL>();
        if (allowedOriginProp != null && !allowedOriginProp.isEmpty()) {
            for (String token : allowedOriginProp.split("[,\\s]+")) {
                if ((token = token.trim()).isEmpty()) continue;
                try {
                    URL element = new URL(token);
                    allowedOriginList.add(element);
                }
                catch (MalformedURLException e) {
                    log.warn("Could not parse allowed origin from " + token, e);
                }
            }
        }
        allowedOrigins = Collections.unmodifiableList(allowedOriginList);
    }
}

