/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class SqlDbUpdaterAction
implements ChangeAction {
    private String sqlContent;
    private File sqlFile;
    private String separator = null;

    public SqlDbUpdaterAction(String sql) {
        this.sqlContent = sql;
    }

    public SqlDbUpdaterAction(File sqlFile) {
        this.sqlFile = sqlFile;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void apply(ConnectionProvider connProvider, Hashtable properties, File baseDir, PropertyResolver resolver) throws ApplyException {
        String sqlStatement = null;
        FileInputStream sqlStream = null;
        try {
            String[] sqlArray;
            Connection conn = connProvider.getConnection();
            if (this.sqlFile != null) {
                File f = new File(baseDir, this.sqlFile.getPath());
                sqlStream = new FileInputStream(f);
                int bufferLength = Math.max(sqlStream.available(), 1024);
                byte[] sqlBytes = new byte[bufferLength];
                StringBuffer buffer = new StringBuffer(bufferLength);
                int len = 0;
                while ((len = sqlStream.read(sqlBytes)) >= 0) {
                    buffer.append(new String(sqlBytes, 0, len));
                }
                sqlArray = this.parseStatements(buffer.toString());
            } else {
                sqlArray = this.parseStatements(this.sqlContent);
            }
            Statement stmt = null;
            if (sqlArray != null) {
                for (String sql : sqlArray) {
                    sqlStatement = sql.trim();
                    if (sqlStatement.length() <= 0) continue;
                    stmt = conn.createStatement();
                    stmt.execute(sqlStatement);
                    stmt.close();
                }
            }
        }
        catch (IOException e) {
            throw new ApplyException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new ApplyException(e.getMessage() + ": " + sqlStatement);
        }
        finally {
            if (sqlStream != null) {
                try {
                    sqlStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String[] parseStatements(String s) {
        String[] result = null;
        result = this.separator == null ? s.split(";;") : s.split(this.separator);
        return result;
    }
}

