/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ConnectionProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class VersionController {
    private final String tableName;
    private final String releaseColumn;
    private final String versionColumn;
    private final ConnectionProvider connProvider;

    VersionController(ConnectionProvider connProvider, String tableName, String releaseColumn, String versionColumn) {
        this.tableName = tableName;
        this.releaseColumn = releaseColumn;
        this.versionColumn = versionColumn;
        this.connProvider = connProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentVersion(String release) throws SQLException {
        Connection conn = this.connProvider.getConnection();
        int currentVersion = 0;
        String sql = "SELECT " + this.versionColumn + " FROM " + this.tableName + " WHERE " + this.releaseColumn + " = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setString(1, release);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    currentVersion = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            System.out.println("Unable to determine version for " + release);
        }
        finally {
            stmt.close();
        }
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentVersion(String release, int version) throws SQLException {
        Connection conn = this.connProvider.getConnection();
        Statement stmt = null;
        try {
            String deleteSql = "DELETE FROM " + this.tableName + " WHERE " + this.releaseColumn + " = ?";
            stmt = conn.prepareStatement(deleteSql);
            stmt.setString(1, release);
            stmt.executeUpdate();
            String insertSql = "INSERT INTO " + this.tableName + " (" + this.releaseColumn + ", " + this.versionColumn + ")" + " VALUES (?, ?)";
            stmt = conn.prepareStatement(insertSql);
            stmt.setString(1, release);
            stmt.setInt(2, version);
            stmt.executeUpdate();
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

