final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def driver = props['driver'];
final def dbJar = props['dbJar'];
final def dbUrl = props['dbUrl']
final def dbUser = props['dbUser'];
final def dbPass = props['dbPass'];
final def sqlFilePath = props['sqlFilePath'];
final def sqlFileInclude = props['sqlFileInclude'];
final def currentVersionSql = props['currentVersionSql'];
final def deleteVersionSql = props['deleteVersionSql'];
final def updateVersionSql = props['updateVersionSql'];

println "Using values : "
println "driver : " + driver
println "dbJar : " + dbJar
println "dbUrl : " + dbUrl
println "dbUser : " + dbUser
println "dbPass : " + dbPass
println "sqlFilePath : " + sqlFilePath
println "sqlFileInclude : " + sqlFileInclude
println "currentVersionSql : " + currentVersionSql
println "deleteVersionSql : " + deleteVersionSql
println "updateVersionSql : " + updateVersionSql

def ant = new AntBuilder();

ant.sequential {
    path id:"drivers.path", {
        fileset dir:".", includes:"${dbJar}"
    }
    taskdef name:"dbupgrade", classname:"com.urbancode.cm.db.updater.DbUpgradeTask"
    dbupgrade driver:"${driver}", url:"${dbUrl}", userid:"${dbUser}", password:"${dbPass}", 
            currentVersionSql:"${currentVersionSql}", deleteVersionSql:"${deleteVersionSql}", updateVersionSql:"${updateVersionSql}",
            classpathref:"drivers.path", {
        fileset dir:"${sqlFilePath}", {
           include name:"${sqlFileInclude}"
        }
    }
}
