/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Hashtable;

public class GroovyDbUpdaterAction
implements ChangeAction {
    private String scriptName;
    private InputStream groovyStream = null;

    public GroovyDbUpdaterAction(String scriptName) {
        this.scriptName = scriptName;
    }

    public GroovyDbUpdaterAction(InputStream groovyStream) {
        this.groovyStream = groovyStream;
    }

    public void apply(ConnectionProvider connProvider, Hashtable properties, File baseDir, PropertyResolver resolver) throws ApplyException {
        try {
            Connection conn = connProvider.getConnection();
            Binding binding = new Binding();
            binding.setVariable("CONN", (Object)conn);
            binding.setVariable("ANT_PROPERTIES", (Object)properties);
            GroovyShell shell = new GroovyShell(binding);
            Script script = null;
            if (this.groovyStream != null) {
                script = shell.parse(this.groovyStream);
            } else {
                File in = new File(baseDir, this.scriptName);
                script = shell.parse(in);
            }
            script.run();
        }
        catch (Exception e) {
            throw new ApplyException(e);
        }
        finally {
            if (this.groovyStream != null) {
                try {
                    this.groovyStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

