/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ConnectionProvider;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.types.FileSet;

public abstract class DbChangeTask
extends JDBCTask {
    private File file;
    private FileSet fileset;
    private String currentVersionSql;
    private String deleteVersionSql;
    private String updateVersionSql;
    private String driver;

    public String getDriverClassName() {
        return this.driver;
    }

    public void setDriver(String driver) {
        super.setDriver(driver);
        this.driver = driver;
    }

    public String getCurrentVersionSql() {
        return this.currentVersionSql;
    }

    public void setCurrentVersionSql(String currentVersionSql) {
        this.currentVersionSql = currentVersionSql;
    }

    public String getUpdateVersionSql() {
        return this.updateVersionSql;
    }

    public void setUpdateVersionSql(String updateVersionSql) {
        this.updateVersionSql = updateVersionSql;
    }

    public String getDeleteVersionSql() {
        return this.deleteVersionSql;
    }

    public void setDeleteVersionSql(String deleteVersionSql) {
        this.deleteVersionSql = deleteVersionSql;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileSet getFileSet() {
        return this.fileset;
    }

    public void addFileSet(FileSet fileset) {
        this.fileset = fileset;
    }

    public abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentVersion(Connection conn) throws SQLException {
        int result = 0;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this.currentVersionSql);
            try {
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentVersion(ConnectionProvider connProvider, int version) throws SQLException {
        Statement stmt = null;
        try {
            Connection conn = connProvider.getConnection();
            if (this.deleteVersionSql != null) {
                stmt = conn.prepareStatement(this.deleteVersionSql);
                stmt.executeUpdate();
            }
            stmt = conn.prepareStatement(this.updateVersionSql);
            stmt.setInt(1, version);
            stmt.executeUpdate();
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentVersion(Connection conn, String release) throws SQLException {
        int result = 0;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(this.currentVersionSql);
            stmt.setString(1, release);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.log("Unable to determine version for " + release);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentVersion(ConnectionProvider connProvider, String release, int version) throws SQLException {
        Statement stmt = null;
        try {
            Connection conn = connProvider.getConnection();
            stmt = conn.prepareStatement(this.deleteVersionSql);
            stmt.setString(1, release);
            stmt.executeUpdate();
            stmt = conn.prepareStatement(this.updateVersionSql);
            stmt.setString(1, release);
            stmt.setInt(2, version);
            stmt.executeUpdate();
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

