/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ConcreteJDBCTask;
import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.Credentials;
import com.urbancode.cm.db.updater.DbChangeTask;
import java.sql.Connection;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.types.Path;

public class AntConnectionProvider
implements ConnectionProvider {
    private final Connection connection;
    private final DbChangeTask task;

    public AntConnectionProvider(Connection connection, DbChangeTask task) {
        this.connection = connection;
        this.task = task;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection createConnection(Credentials credentials) {
        String rdbms;
        String version;
        String taskType;
        String taskName;
        RuntimeConfigurable runtimeConfigurable;
        Target owningTarget;
        Location location;
        Project project;
        String description;
        String driverClassName;
        ConcreteJDBCTask jdbcTask = new ConcreteJDBCTask();
        jdbcTask.setUrl(credentials.getUrl());
        jdbcTask.setUserid(credentials.getUsername());
        jdbcTask.setPassword(credentials.getPassword());
        jdbcTask.setAutocommit(this.task.isAutocommit());
        Path classpath = this.task.getClasspath();
        if (classpath != null) {
            jdbcTask.setClasspath(classpath);
        }
        if ((driverClassName = this.task.getDriverClassName()) != null) {
            jdbcTask.setDriver(driverClassName);
        }
        if ((description = this.task.getDescription()) != null) {
            jdbcTask.setDescription(description);
        }
        if ((project = this.task.getProject()) != null) {
            jdbcTask.setProject(project);
        }
        if ((location = this.task.getLocation()) != null) {
            jdbcTask.setLocation(location);
        }
        if ((owningTarget = this.task.getOwningTarget()) != null) {
            jdbcTask.setOwningTarget(owningTarget);
        }
        if ((runtimeConfigurable = this.task.getRuntimeConfigurableWrapper()) != null) {
            jdbcTask.setRuntimeConfigurableWrapper(runtimeConfigurable);
        }
        if ((taskName = this.task.getTaskName()) != null) {
            jdbcTask.setTaskName(taskName);
        }
        if ((taskType = this.task.getTaskType()) != null) {
            jdbcTask.setTaskType(taskType);
        }
        if ((version = this.task.getVersion()) != null) {
            jdbcTask.setVersion(version);
        }
        if ((rdbms = this.task.getRdbms()) != null) {
            jdbcTask.setRdbms(rdbms);
        }
        return jdbcTask.createConnection();
    }
}

