/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.Macro;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQLCharOfMacro
extends Macro {
    static final Pattern idPattern = Pattern.compile("^([_a-zA-Z0-9]+)$");
    private Connection connection;
    private PreparedStatement columnCollationQuery;
    private Map<CacheKey, String> cache;

    public MySQLCharOfMacro(Connection connection) {
        connection.getClass();
        this.connection = connection;
    }

    public String expand(String sql) throws SQLException {
        String macroPrefix = "\\MYSQL_CHAROF(";
        int macroBegin = 0;
        int macroEnd = 0;
        while ((macroBegin = sql.indexOf(macroPrefix, macroEnd)) >= 0) {
            int argBegin = macroBegin + macroPrefix.length();
            int argEnd = sql.indexOf(41, argBegin);
            if (argEnd >= 0) {
                macroEnd = argEnd + 1;
                String args = sql.substring(argBegin, argEnd);
                String[] parsedArgs = this.parseArguments(args);
                if (parsedArgs == null || parsedArgs.length != 2) continue;
                String table = parsedArgs[0];
                String column = parsedArgs[1];
                String expansion = this.getExpansion(table, column);
                String prefix = sql.substring(0, macroBegin);
                String suffix = sql.substring(macroEnd);
                sql = prefix + expansion + suffix;
                continue;
            }
            macroEnd = argBegin + 1;
        }
        return sql;
    }

    private PreparedStatement getColumnCollationQuery() throws SQLException {
        if (this.columnCollationQuery == null) {
            this.columnCollationQuery = this.connection.prepareStatement("select   character_set_name,   collation_name from   information_schema.columns where   table_schema = ?   and table_name = ?   and column_name = ?");
        }
        return this.columnCollationQuery;
    }

    private String[] parseArguments(String args) {
        Matcher m = idPattern.matcher("");
        String[] parts = args.split(",", -1);
        if (parts.length != 2) {
            return null;
        }
        for (int i = 0; i < parts.length; ++i) {
            if (!m.reset(parts[i].trim()).matches()) {
                return null;
            }
            parts[i] = m.group(1);
        }
        return parts;
    }

    private String getExpansion(String table, String column) throws SQLException {
        CacheKey key = new CacheKey(table, column);
        String expansion = this.getCachedExpansion(key);
        if (expansion != null) {
            return expansion;
        }
        expansion = this.getColumnCharsetAndCollation(table, column);
        this.cacheExpansion(key, expansion);
        return expansion;
    }

    private String getCachedExpansion(CacheKey key) {
        key.getClass();
        if (this.cache != null) {
            return this.cache.get(key);
        }
        return null;
    }

    private void cacheExpansion(CacheKey key, String expansion) {
        key.getClass();
        expansion.getClass();
        if (this.cache == null) {
            this.cache = new HashMap<CacheKey, String>();
        }
        this.cache.put(key, expansion);
    }

    private String getColumnCharsetAndCollation(String table, String column) throws SQLException {
        String schema = this.getSchema(table, column);
        PreparedStatement q = this.getColumnCollationQuery();
        q.setString(1, schema);
        q.setString(2, table);
        q.setString(3, column);
        ResultSet rs = q.executeQuery();
        try {
            if (rs.next()) {
                String charset = rs.getString(1);
                String collation = rs.getString(2);
                if (charset == null) {
                    throw new NotTextColumnException(String.format("charset is undefined: schema=%s table=%s column=%s", schema, table, column));
                }
                if (collation == null) {
                    throw new NotTextColumnException(String.format("collation is undefined: schema=%s table=%s column=%s", schema, table, column));
                }
                String string = String.format("character set %s collate %s", charset, collation);
                return string;
            }
            if (rs.next()) {
                throw new NoColumnInfoException(String.format("column is ambiguous: schema=%s table=%s column=%s", schema, table, column));
            }
            throw new NoColumnInfoException(String.format("cannot find column info: schema=%s table=%s column=%s", schema, table, column));
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSchema(String table, String column) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("select " + column + " from " + table + " where 1 = 0");
        try {
            String string;
            ResultSet rs = stmt.executeQuery();
            try {
                string = rs.getMetaData().getCatalogName(1);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    static final class CacheKey {
        final String table;
        final String column;

        CacheKey(String table, String column) {
            this.table = table;
            this.column = column;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hash(this.table);
            result = 31 * result + this.hash(this.column);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof CacheKey) {
                CacheKey rhs = (CacheKey)obj;
                return this.eq(this.table, rhs.table) && this.eq(this.column, rhs.column);
            }
            return false;
        }

        private boolean eq(Object x, Object y) {
            return x == y || x != null && x.equals(y);
        }

        private int hash(Object o) {
            if (o == null) {
                return 0;
            }
            return o.hashCode();
        }
    }

    static class NoColumnInfoException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoColumnInfoException(String message) {
            super(message);
        }
    }

    static class NotTextColumnException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotTextColumnException(String message) {
            super(message);
        }
    }
}

