/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.AntConnectionProvider;
import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ChangeActionFactory;
import com.urbancode.cm.db.updater.DbChangeTask;
import com.urbancode.cm.db.updater.XMLChangeComparator;
import com.urbancode.cm.db.updater.XMLChangeSetFileParser;
import com.urbancode.cm.db.updater.jaxb.XMLAction;
import com.urbancode.cm.db.updater.jaxb.XMLChange;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSet;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSetComparator;
import com.urbancode.cm.db.updater.properties.AntPropertyResolver;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;

public class DbUpgradeTask
extends DbChangeTask {
    public void execute() throws BuildException {
        AntPropertyResolver resolver = new AntPropertyResolver(super.getProject());
        File file = this.getFile();
        FileSet fileset = this.getFileSet();
        if (file == null && fileset == null) {
            throw new BuildException("Either the 'file' attribute or a 'fileset' element must be defined.");
        }
        if (file != null && !file.isFile()) {
            throw new BuildException(file.getAbsolutePath() + " not found");
        }
        if (fileset != null && fileset.size() == 0) {
            throw new BuildException("Fileset contains no files");
        }
        if (file != null) {
            this.executeSingleVersionUpgrade(resolver);
        } else {
            this.executeMultiVersionUpgrade(resolver);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeSingleVersionUpgrade(PropertyResolver resolver) {
        File file = this.getFile();
        Connection conn = null;
        try {
            conn = super.getConnection();
            AntConnectionProvider connProvider = new AntConnectionProvider(conn, this);
            int version = this.getCurrentVersion(conn);
            this.log("Found current version: " + version);
            Hashtable properties = this.getProject().getProperties();
            File baseDir = this.getProject().getBaseDir();
            ChangeActionFactory actionFactory = new ChangeActionFactory();
            XMLChangeSetFileParser parser = new XMLChangeSetFileParser();
            XMLChangeSet changeSet = parser.parseChangeSet(file);
            List<XMLChange> changeList = changeSet.getChange();
            Collections.sort(changeList, new XMLChangeComparator());
            for (XMLChange change : changeList) {
                if (!this.isRunnableVersion(change.getNumber(), version)) continue;
                try {
                    conn.setAutoCommit(this.isAutocommit());
                    StringBuilder sb = new StringBuilder("Applying change: ");
                    sb.append(change.getNumber());
                    String description = change.getDescription();
                    if (description != null && (description = description.trim()).length() > 0) {
                        sb.append(" - ").append(description);
                    }
                    this.log(sb.toString());
                    for (XMLAction xmlAction : change.getSqlOrJavaOrGroovy()) {
                        ChangeAction dbAction = actionFactory.getActionFromXML(changeSet, xmlAction);
                        dbAction.apply(connProvider, properties, baseDir, resolver);
                    }
                    this.setCurrentVersion(connProvider, change.getNumber());
                }
                catch (Exception e) {
                    conn.rollback();
                    throw e;
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ApplyException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e) {}
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("Error occurred closing connection to database");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeMultiVersionUpgrade(PropertyResolver resolver) {
        FileSet fileset = this.getFileSet();
        Connection conn = null;
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            for (Resource resource : fileset) {
                File resourceFile = new File(resource.toString());
                if (resourceFile.isFile()) {
                    this.log("Adding upgrade file for processing: " + resourceFile);
                    fileList.add(resourceFile);
                    continue;
                }
                this.log("Ignoring file from fileset for processing: " + resourceFile);
            }
            Hashtable properties = this.getProject().getProperties();
            File baseDir = this.getProject().getBaseDir();
            ChangeActionFactory actionFactory = new ChangeActionFactory();
            ArrayList<XMLChangeSet> changeSetList = new ArrayList<XMLChangeSet>();
            XMLChangeSetFileParser parser = new XMLChangeSetFileParser();
            for (File releaseFile : fileList) {
                XMLChangeSet changeSet = parser.parseChangeSet(releaseFile);
                if (changeSet.getRelease() == null) {
                    throw new Exception("DB Upgrade file changeset is missing release identifier: " + releaseFile);
                }
                changeSetList.add(changeSet);
            }
            Collections.sort(changeSetList, new XMLChangeSetComparator());
            conn = super.getConnection();
            AntConnectionProvider connProvider = new AntConnectionProvider(conn, this);
            for (XMLChangeSet changeSet : changeSetList) {
                this.log("Processing change set release " + changeSet.getRelease());
                int version = this.getCurrentVersion(conn, changeSet.getRelease());
                this.log("Found " + changeSet.getRelease() + " current version: " + version);
                List<XMLChange> changeList = changeSet.getChange();
                Collections.sort(changeList, new XMLChangeComparator());
                for (XMLChange change : changeList) {
                    if (!this.isRunnableVersion(change.getNumber(), changeSet.getRelease(), version)) continue;
                    try {
                        conn.setAutoCommit(this.isAutocommit());
                        StringBuilder sb = new StringBuilder("Applying ");
                        sb.append(changeSet.getRelease());
                        sb.append(" change: ");
                        sb.append(change.getNumber());
                        if (change.getDescription() != null) {
                            sb.append(" - ").append(change.getDescription().trim());
                        }
                        this.log(sb.toString());
                        for (XMLAction xmlAction : change.getSqlOrJavaOrGroovy()) {
                            ChangeAction dbAction = actionFactory.getActionFromXML(changeSet, xmlAction);
                            dbAction.apply(connProvider, properties, baseDir, resolver);
                        }
                        this.setCurrentVersion(connProvider, changeSet.getRelease(), change.getNumber());
                    }
                    catch (Exception e) {
                        conn.rollback();
                        throw e;
                    }
                }
                continue;
                return;
            }
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ApplyException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e) {}
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("Error occurred closing connection to database");
                    e.printStackTrace();
                }
            }
        }
    }

    protected boolean isRunnableVersion(int changeNumber, String release, int version) {
        return this.isRunnableVersion(changeNumber, version);
    }

    protected boolean isRunnableVersion(int changeNumber, int version) {
        return changeNumber > version;
    }
}

