/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.AntConnectionProvider;
import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ChangeActionFactory;
import com.urbancode.cm.db.updater.DbChangeTask;
import com.urbancode.cm.db.updater.MacroProcessor;
import com.urbancode.cm.db.updater.XMLChangeComparator;
import com.urbancode.cm.db.updater.XMLChangeSetFileParser;
import com.urbancode.cm.db.updater.jaxb.XMLAction;
import com.urbancode.cm.db.updater.jaxb.XMLChange;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSet;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSetComparator;
import com.urbancode.cm.db.updater.jaxb.XMLRollback;
import com.urbancode.cm.db.updater.properties.AntPropertyResolver;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;

public class DbRollbackTask
extends DbChangeTask {
    private String targetVersion;

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void execute() throws BuildException {
        AntPropertyResolver resolver = new AntPropertyResolver(super.getProject());
        File file = this.getFile();
        FileSet fileset = this.getFileSet();
        if (file == null && fileset == null) {
            throw new BuildException("Either the 'file' attribute or a 'fileset' element must be defined.");
        }
        if (file != null && !file.isFile()) {
            throw new BuildException(file.getAbsolutePath() + " not found");
        }
        if (fileset != null && fileset.size() == 0) {
            throw new BuildException("Fileset contains no files");
        }
        if (file != null) {
            this.executeSingleVersionRollback(resolver);
        } else {
            this.executeMultiVersionRollback(resolver);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeSingleVersionRollback(PropertyResolver resolver) {
        File file = this.getFile();
        Connection conn = null;
        try {
            conn = super.getConnection();
            AntConnectionProvider connProvider = new AntConnectionProvider(conn, this);
            int currentVersion = this.getCurrentVersion(conn);
            this.log("Found current version: " + currentVersion);
            Hashtable properties = this.getProject().getProperties();
            File baseDir = this.getProject().getBaseDir();
            ChangeActionFactory actionFactory = new ChangeActionFactory();
            XMLChangeSetFileParser parser = new XMLChangeSetFileParser();
            XMLChangeSet changeSet = parser.parseChangeSet(file);
            List<XMLChange> changeList = changeSet.getChange();
            Collections.sort(changeList, new XMLChangeComparator());
            Collections.reverse(changeList);
            Integer targetVersionInt = null;
            if (this.targetVersion != null && this.targetVersion.length() > 0) {
                targetVersionInt = Integer.valueOf(this.targetVersion);
            }
            for (XMLChange change : changeList) {
                if (change.getNumber() > currentVersion || targetVersionInt != null && change.getNumber() <= targetVersionInt) continue;
                try {
                    conn.setAutoCommit(false);
                    StringBuilder sb = new StringBuilder("Rolling back change: ");
                    sb.append(change.getNumber());
                    String description = change.getDescription();
                    if (description != null && (description = description.trim()).length() > 0) {
                        sb.append(" - ").append(description);
                    }
                    this.log(sb.toString());
                    XMLRollback rollback = change.getRollback();
                    if (rollback != null) {
                        for (XMLAction xmlAction : rollback.getSqlOrJavaOrGroovy()) {
                            ChangeAction dbAction = actionFactory.getActionFromXML(changeSet, xmlAction);
                            if (dbAction instanceof MacroProcessor) {
                                ((MacroProcessor)((Object)dbAction)).addMacros(this.getMacros(conn));
                            }
                            dbAction.apply(connProvider, properties, baseDir, resolver);
                        }
                    }
                    this.setCurrentVersion(connProvider, change.getNumber() - 1);
                }
                catch (Exception e) {
                    conn.rollback();
                    throw e;
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ApplyException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("Error occurred closing connection to database");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeMultiVersionRollback(PropertyResolver resolver) {
        FileSet fileset = this.getFileSet();
        Connection conn = null;
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            for (Resource resource : fileset) {
                File resourceFile = new File(resource.toString());
                if (resourceFile.isFile()) {
                    this.log("Adding upgrade file for processing: " + resourceFile);
                    fileList.add(resourceFile);
                    continue;
                }
                this.log("Ignoring file from fileset for processing: " + resourceFile);
            }
            Hashtable properties = this.getProject().getProperties();
            File baseDir = this.getProject().getBaseDir();
            ChangeActionFactory actionFactory = new ChangeActionFactory();
            XMLChangeSetFileParser parser = new XMLChangeSetFileParser();
            ArrayList<XMLChangeSet> changeSetList = new ArrayList<XMLChangeSet>();
            for (File releaseFile : fileList) {
                XMLChangeSet changeSet = parser.parseChangeSet(releaseFile);
                if (changeSet.getRelease() == null) {
                    throw new Exception("DB Upgrade file changeset is missing release identifier: " + releaseFile);
                }
                changeSetList.add(changeSet);
            }
            Collections.sort(changeSetList, new XMLChangeSetComparator());
            Collections.reverse(changeSetList);
            conn = super.getConnection();
            AntConnectionProvider connProvider = new AntConnectionProvider(conn, this);
            for (XMLChangeSet changeSet : changeSetList) {
                this.log("Processing change set release " + changeSet.getRelease());
                int currentVersion = this.getCurrentVersion(conn, changeSet.getRelease());
                this.log("Found " + changeSet.getRelease() + " current version: " + currentVersion);
                List<XMLChange> changeList = changeSet.getChange();
                Collections.sort(changeList, new XMLChangeComparator());
                Collections.reverse(changeList);
                Integer targetVersionInt = null;
                if (this.targetVersion != null && this.targetVersion.length() > 0) {
                    targetVersionInt = Integer.valueOf(this.targetVersion);
                }
                for (XMLChange change : changeList) {
                    if (change.getNumber() > currentVersion || targetVersionInt != null && change.getNumber() <= targetVersionInt) continue;
                    try {
                        conn.setAutoCommit(false);
                        StringBuilder sb = new StringBuilder("Rolling back ");
                        sb.append(changeSet.getRelease());
                        sb.append(" change: ");
                        sb.append(change.getNumber());
                        if (change.getDescription() != null) {
                            sb.append(" - ").append(change.getDescription().trim());
                        }
                        this.log(sb.toString());
                        XMLRollback rollback = change.getRollback();
                        if (rollback != null) {
                            for (XMLAction xmlAction : rollback.getSqlOrJavaOrGroovy()) {
                                ChangeAction dbAction = actionFactory.getActionFromXML(changeSet, xmlAction);
                                if (dbAction instanceof MacroProcessor) {
                                    ((MacroProcessor)((Object)dbAction)).addMacros(this.getMacros(conn));
                                }
                                dbAction.apply(connProvider, properties, baseDir, resolver);
                            }
                        }
                        this.setCurrentVersion(connProvider, changeSet.getRelease(), change.getNumber() - 1);
                    }
                    catch (Exception e) {
                        conn.rollback();
                        throw e;
                    }
                }
                continue;
                return;
            }
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ApplyException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("Error occurred closing connection to database");
                    e.printStackTrace();
                }
            }
        }
    }
}

