/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDbUpdaterAction
implements ChangeAction {
    private String className;
    private Object obj;

    protected JavaDbUpdaterAction(String className) {
        this.className = className;
    }

    protected JavaDbUpdaterAction(Object obj) {
        this.obj = obj;
    }

    @Override
    public void apply(ConnectionProvider connProvider, Hashtable properties, File baseDir, PropertyResolver resolver) throws ApplyException {
        try {
            Connection conn = connProvider.getConnection();
            this.initInstance();
            this.invokeMethod(this.obj, "setConnection", new Class[]{Connection.class}, conn);
            this.invokeMethod(this.obj, "setProperties", new Class[]{Map.class}, properties);
            this.invokeMethod(this.obj, "setBaseDir", new Class[]{File.class}, baseDir);
            this.invokeMethod(this.obj, "setPropertyResolver", new Class[]{PropertyResolver.class}, resolver);
            Method runMethod = this.obj.getClass().getMethod("run", new Class[0]);
            runMethod.invoke(this.obj, new Object[0]);
        }
        catch (Exception e) {
            throw new ApplyException(e);
        }
    }

    protected void initInstance() throws ClassNotFoundException, ReflectiveOperationException {
        if (this.obj == null) {
            Class<?> c = Class.forName(this.className);
            this.obj = c.newInstance();
        }
    }

    protected void invokeMethod(Object instance, String methodName, Class<?>[] parameterTypes, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Class<?> c = instance.getClass();
            Method method = c.getMethod(methodName, parameterTypes);
            method.invoke(instance, args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

