/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.properties.PropertyResolver;
import org.apache.commons.lang.StringUtils;

public class Credentials {
    private String username;
    private String password;
    private String url;

    public Credentials(String username, String password, String url, PropertyResolver resolver) {
        this.username = resolver.evaluateExpression(username);
        this.password = resolver.evaluateExpression(password);
        this.url = resolver.evaluateExpression(url);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean hasUserDefinedCredentials() {
        boolean result = false;
        this.validateCredentials();
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password) && StringUtils.isNotBlank((String)this.url)) {
            result = true;
        }
        return result;
    }

    private void validateCredentials() throws IllegalArgumentException {
        if (StringUtils.isNotBlank((String)this.username) ? StringUtils.isBlank((String)this.password) || StringUtils.isBlank((String)this.url) : StringUtils.isNotBlank((String)this.password) || StringUtils.isNotBlank((String)this.url)) {
            throw new IllegalArgumentException("If a username, password, or URL is supplied, all three attributes must have values.");
        }
    }
}

