/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def workDir = new File('.').canonicalFile

final def driver = props['driver'];
final def dbJar = props['dbJar'];
final def dbUrl = props['dbUrl']
final def dbUser = props['dbUser'];
final def dbPass = props['dbPass'];
final def sqlFilePath = props['sqlFilePath'];
final def sqlFileInclude = props['sqlFileInclude'];
final def currentVersionSql = props['currentVersionSql'];
final def deleteVersionSql = props['deleteVersionSql'];
final def updateVersionSql = props['updateVersionSql'];

println "Using values : "
println "driver : " + driver
println "dbJar : " + dbJar
println "dbUrl : " + dbUrl
println "dbUser : " + dbUser
println "dbPass : " + dbPass
println "sqlFilePath : " + sqlFilePath
println "sqlFileInclude : " + sqlFileInclude
println "currentVersionSql : " + currentVersionSql
println "deleteVersionSql : " + deleteVersionSql
println "updateVersionSql : " + updateVersionSql

def driverFileDir = "."
def driverFile = new File(dbJar).getAbsoluteFile();
driverFileDir = driverFile.getParent()
dbJar = driverFile.getName()

def ant = new AntBuilder();

ant.sequential {
    path id:"drivers.path", {
        fileset dir:"${driverFileDir}", includes:"${dbJar}"
    }
    taskdef name:"dbupgrade", classname:"com.urbancode.cm.db.updater.DbUpgradeTask"
    dbupgrade driver:"${driver}", url:"${dbUrl}", userid:"${dbUser}", password:"${dbPass}",
            currentVersionSql:"${currentVersionSql}", deleteVersionSql:"${deleteVersionSql}", updateVersionSql:"${updateVersionSql}",
            classpathref:"drivers.path", {
        fileset dir:"${sqlFilePath}", {
           include name:"${sqlFileInclude}"
        }
    }
}
