/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ChangeRefAction;
import com.urbancode.cm.db.updater.GroovyDbUpdaterAction;
import com.urbancode.cm.db.updater.JavaDbUpdaterAction;
import com.urbancode.cm.db.updater.SqlDbUpdaterAction;
import com.urbancode.cm.db.updater.jaxb.XMLAction;
import com.urbancode.cm.db.updater.jaxb.XMLChangeRefAction;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSet;
import com.urbancode.cm.db.updater.jaxb.XMLGroovyAction;
import com.urbancode.cm.db.updater.jaxb.XMLJavaAction;
import com.urbancode.cm.db.updater.jaxb.XMLLibrary;
import com.urbancode.cm.db.updater.jaxb.XMLSqlAction;
import java.io.ByteArrayInputStream;
import java.io.File;

public class ChangeActionFactory {
    public ChangeAction getActionFromXML(XMLChangeSet xmlChangeSet, XMLAction xmlAction) throws Exception {
        if (xmlAction instanceof XMLSqlAction) {
            return this.getSqlActionFromXML((XMLSqlAction)xmlAction);
        }
        if (xmlAction instanceof XMLJavaAction) {
            return this.getJavaActionFromXML((XMLJavaAction)xmlAction);
        }
        if (xmlAction instanceof XMLGroovyAction) {
            return this.getGroovyActionFromXML((XMLGroovyAction)xmlAction);
        }
        if (xmlAction instanceof XMLChangeRefAction) {
            return this.getChangeRefActionFromXML(xmlChangeSet, (XMLChangeRefAction)xmlAction);
        }
        throw new Exception("Unrecognized XML action: " + xmlAction.getClass().getName());
    }

    public SqlDbUpdaterAction getSqlActionFromXML(XMLSqlAction xmlAction) throws Exception {
        SqlDbUpdaterAction result = null;
        if (xmlAction.getFile() != null) {
            File file = new File(xmlAction.getFile());
            result = new SqlDbUpdaterAction(file);
        } else if (xmlAction.getContent() != null) {
            result = new SqlDbUpdaterAction(xmlAction.getContent());
        } else {
            throw new Exception("Either a file attribute must be specified or script content must be supplied for a <sql> action.");
        }
        if (xmlAction.getSeparator() != null && xmlAction.getSeparator().length() > 0) {
            result.setSeparator(xmlAction.getSeparator());
        }
        return result;
    }

    public JavaDbUpdaterAction getJavaActionFromXML(XMLJavaAction xmlAction) throws Exception {
        return new JavaDbUpdaterAction(xmlAction.getClazz());
    }

    public GroovyDbUpdaterAction getGroovyActionFromXML(XMLGroovyAction xmlAction) throws Exception {
        if (xmlAction.getFile() != null) {
            return new GroovyDbUpdaterAction(xmlAction.getFile());
        }
        if (xmlAction.getContent() != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(xmlAction.getContent().getBytes());
            return new GroovyDbUpdaterAction(stream);
        }
        throw new Exception("Either a file attribute must be specified or script content must be supplied for a <groovy> action.");
    }

    public ChangeRefAction getChangeRefActionFromXML(XMLChangeSet xmlChangeSet, XMLChangeRefAction xmlAction) throws Exception {
        if (xmlAction.getLibrary() == null) {
            throw new Exception("A library attribute is required for a <library> action.");
        }
        XMLLibrary matchingXmlLibrary = null;
        for (XMLLibrary xmlLibrary : xmlChangeSet.getLibrary()) {
            if (!xmlAction.getLibrary().equals(xmlLibrary.getName())) continue;
            matchingXmlLibrary = xmlLibrary;
            break;
        }
        if (matchingXmlLibrary == null) {
            throw new Exception("No <library> defined for '" + xmlAction.getLibrary() + "'");
        }
        return new ChangeRefAction(matchingXmlLibrary, xmlAction.getChange());
    }
}

