/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.Macro;
import com.urbancode.cm.db.updater.MySQLCharOfMacro;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.JDBCTask;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbChangeTask
extends JDBCTask {
    private File file;
    private FileSet fileset;
    private String currentVersionSql;
    private String deleteVersionSql;
    private String updateVersionSql;
    private String connectionInitSql;
    private String driver;

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String sql) {
        this.connectionInitSql = sql;
    }

    protected Connection getConnection() throws BuildException {
        Connection conn = super.getConnection();
        if (conn != null && this.connectionInitSql != null) {
            try {
                PreparedStatement stmt = conn.prepareStatement(this.connectionInitSql);
                stmt.execute();
                stmt.close();
            }
            catch (SQLException e) {
                throw new BuildException("Could not execute connection init sql", (Throwable)e);
            }
        }
        return conn;
    }

    public String getDriverClassName() {
        return this.driver;
    }

    public void setDriver(String driver) {
        super.setDriver(driver);
        this.driver = driver;
    }

    public String getCurrentVersionSql() {
        return this.currentVersionSql;
    }

    public void setCurrentVersionSql(String currentVersionSql) {
        this.currentVersionSql = currentVersionSql;
    }

    public String getUpdateVersionSql() {
        return this.updateVersionSql;
    }

    public void setUpdateVersionSql(String updateVersionSql) {
        this.updateVersionSql = updateVersionSql;
    }

    public String getDeleteVersionSql() {
        return this.deleteVersionSql;
    }

    public void setDeleteVersionSql(String deleteVersionSql) {
        this.deleteVersionSql = deleteVersionSql;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileSet getFileSet() {
        return this.fileset;
    }

    public void addFileSet(FileSet fileset) {
        this.fileset = fileset;
    }

    public abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentVersion(Connection conn) throws SQLException {
        int result = 0;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(this.currentVersionSql);
            try {
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentVersion(ConnectionProvider connProvider, int version) throws SQLException {
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            Connection conn = connProvider.getConnection();
            if (this.deleteVersionSql != null) {
                stmt = conn.prepareStatement(this.deleteVersionSql);
                stmt.executeUpdate();
            }
            stmt2 = conn.prepareStatement(this.updateVersionSql);
            stmt2.setInt(1, version);
            stmt2.executeUpdate();
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (stmt2 != null) {
                stmt2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentVersion(Connection conn, String release) throws SQLException {
        int result = 0;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(this.currentVersionSql);
            stmt.setString(1, release);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException e) {
            this.log("Unable to determine version for " + release);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentVersion(ConnectionProvider connProvider, String release, int version) throws SQLException {
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            Connection conn = connProvider.getConnection();
            stmt = conn.prepareStatement(this.deleteVersionSql);
            stmt.setString(1, release);
            stmt.executeUpdate();
            stmt2 = conn.prepareStatement(this.updateVersionSql);
            stmt2.setString(1, release);
            stmt2.setInt(2, version);
            stmt2.executeUpdate();
            conn.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (stmt2 != null) {
                stmt2.close();
            }
        }
    }

    protected List<Macro> getMacros(Connection connection) {
        ArrayList<Macro> macros = new ArrayList<Macro>();
        macros.add(new MySQLCharOfMacro(connection));
        return macros;
    }
}

