/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.cm.db.updater;

import com.urbancode.cm.db.updater.ApplyException;
import com.urbancode.cm.db.updater.ChangeAction;
import com.urbancode.cm.db.updater.ChangeActionFactory;
import com.urbancode.cm.db.updater.ConnectionProvider;
import com.urbancode.cm.db.updater.Credentials;
import com.urbancode.cm.db.updater.LibraryConnectionProvider;
import com.urbancode.cm.db.updater.Macro;
import com.urbancode.cm.db.updater.MacroProcessor;
import com.urbancode.cm.db.updater.VersionController;
import com.urbancode.cm.db.updater.XMLChangeSetFileParser;
import com.urbancode.cm.db.updater.jaxb.XMLAction;
import com.urbancode.cm.db.updater.jaxb.XMLChange;
import com.urbancode.cm.db.updater.jaxb.XMLChangeSet;
import com.urbancode.cm.db.updater.jaxb.XMLLibrary;
import com.urbancode.cm.db.updater.properties.PropertyResolver;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRefAction
implements ChangeAction,
MacroProcessor {
    private final XMLLibrary library;
    private final int changeNumber;
    private List<Macro> macros;

    public ChangeRefAction(XMLLibrary library, int changeNumber) {
        if (library == null) {
            throw new IllegalArgumentException("library is required");
        }
        this.library = library;
        this.changeNumber = changeNumber;
    }

    @Override
    public void addMacros(List<Macro> macros) {
        if (macros != null && !macros.isEmpty()) {
            if (this.macros == null) {
                this.macros = new ArrayList<Macro>();
            }
            this.macros.addAll(macros);
        }
    }

    @Override
    public void apply(ConnectionProvider connProvider, Hashtable properties, File baseDir, PropertyResolver resolver) throws ApplyException {
        XMLChangeSet xmlChangeSet;
        Connection conn = connProvider.getConnection();
        XMLChangeSetFileParser parser = new XMLChangeSetFileParser();
        File file = new File(baseDir, this.library.getFile());
        try {
            xmlChangeSet = parser.parseChangeSet(file);
        }
        catch (JAXBException e) {
            throw new ApplyException(this.library.getFile() + " could not be parsed as a change set XML file: " + e.getMessage(), e);
        }
        String release = this.getRelease(xmlChangeSet);
        int currentVersion = this.getCurrentVersion(connProvider, release);
        if (currentVersion < this.changeNumber) {
            Credentials credentials = this.getCredentials(resolver);
            VersionController versionController = this.getVersionController(connProvider);
            if (credentials.hasUserDefinedCredentials()) {
                this.applyChangeWithLibraryConnection(connProvider, versionController, credentials, properties, baseDir, xmlChangeSet, resolver);
            } else {
                this.applyChange(connProvider, versionController, properties, baseDir, xmlChangeSet, resolver);
            }
        }
    }

    private Credentials getCredentials(PropertyResolver resolver) {
        Credentials credentials = null;
        String username = this.library.getUsername();
        String password = this.library.getPassword();
        String url = this.library.getUrl();
        credentials = new Credentials(username, password, url, resolver);
        return credentials;
    }

    private String getRelease(XMLChangeSet xmlChangeSet) {
        return this.library.getRelease() != null ? this.library.getRelease() : xmlChangeSet.getRelease();
    }

    private int getCurrentVersion(ConnectionProvider connProvider, String release) throws ApplyException {
        try {
            VersionController versionController = this.getVersionController(connProvider);
            return versionController.getCurrentVersion(release);
        }
        catch (SQLException e) {
            throw new ApplyException("Unable to get the current version for release '" + release + "': " + e.getMessage(), e);
        }
    }

    private VersionController getVersionController(ConnectionProvider connProvider) {
        return new VersionController(connProvider, this.library.getVersionTable(), this.library.getReleaseColumn(), this.library.getVersionColumn());
    }

    void applyChange(ConnectionProvider connProvider, VersionController versionController, Hashtable properties, File baseDir, XMLChangeSet xmlChangeSet, PropertyResolver resolver) throws ApplyException {
        boolean found = false;
        Connection conn = connProvider.getConnection();
        List<XMLChange> changeList = xmlChangeSet.getChange();
        for (XMLChange change : changeList) {
            if (this.changeNumber != change.getNumber()) continue;
            found = true;
            String release = this.getRelease(xmlChangeSet);
            try {
                ChangeActionFactory actionFactory = new ChangeActionFactory();
                File libraryBaseDir = new File(baseDir, this.library.getBaseDir());
                for (XMLAction xmlAction : change.getSqlOrJavaOrGroovy()) {
                    ChangeAction dbAction = actionFactory.getActionFromXML(xmlChangeSet, xmlAction);
                    if (dbAction instanceof MacroProcessor && this.macros != null) {
                        ((MacroProcessor)((Object)dbAction)).addMacros(this.macros);
                    }
                    dbAction.apply(connProvider, properties, libraryBaseDir, resolver);
                }
                versionController.setCurrentVersion(release, this.changeNumber);
                break;
            }
            catch (Exception e) {
                throw new ApplyException("Error applying change " + this.changeNumber + " for release '" + release + "'", e);
            }
        }
        if (!found) {
            throw new ApplyException("Error applying change " + this.changeNumber + ". The change could not be found.");
        }
    }

    private void applyChangeWithLibraryConnection(ConnectionProvider connProvider, VersionController versionController, Credentials credentials, Hashtable properties, File baseDir, XMLChangeSet xmlChangeSet, PropertyResolver resolver) {
        Connection connection = null;
        try {
            try {
                connection = connProvider.createConnection(credentials);
                LibraryConnectionProvider libraryProvider = new LibraryConnectionProvider(connection);
                this.applyChange(libraryProvider, versionController, properties, baseDir, xmlChangeSet, resolver);
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {}
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    System.err.println("There was an error closing the user-defined connection to the database: " + e.toString());
                }
            }
        }
    }
}

