package com.urbancode.air.plugin.DeployTools
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

import org.apache.http.HttpResponse;

import com.urbancode.air.AirPluginTool
import com.urbancode.commons.util.IO;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;

public class HttpHelper {
    def apTool
    def props = []
    DefaultHttpClient client
    
    public HttpHelper(def apToolIn) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        HttpClientBuilder builder = new HttpClientBuilder()
        builder.setPreemptiveAuthentication(true)
        builder.setUsername(apTool.getAuthTokenUsername())
        builder.setPassword(apTool.getAuthToken())
        client = builder.buildClient()
    }
    
    public HttpHelper(def apToolIn, def username, def password) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        HttpClientBuilder builder = new HttpClientBuilder()
        builder.setPreemptiveAuthentication(true)
        builder.setUsername(username)
        builder.setPassword(password)
        client = builder.buildClient()
        
    }
    
    public String getBody(HttpResponse response)
    throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            Reader reader = IO.reader(body, IO.utf8());
            try {
                IO.copy(reader, builder);
            }
            finally {
                reader.close();
            }
        }
        return builder.toString();
    }
}