/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.ConnectionCleaner;
import com.urbancode.commons.httpcomponentsutil.FlexibleSSLSocketFactory;
import com.urbancode.commons.httpcomponentsutil.PreemptiveAuthHttpClient;
import com.urbancode.commons.httpcomponentsutil.TimeoutHelper;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import com.urbancode.commons.util.ssl.SSLContextProtocolDetector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;

public class HttpClientBuilder {
    private boolean trustAllCerts = false;
    private int timeoutMillis = -1;
    private String username = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean preemptiveAuthentication = false;
    private int maxConnsPerRoute = -1;
    private int maxConns = -1;
    private long idleConnectionTimeout = 30000L;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    ClientConnectionManager connectionManager = null;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    @Deprecated
    public void setTimeoutRetry(int timeoutRetry) {
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionManager(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        if (connectionManager != null) {
            this.maxConnsPerRoute = -1;
            this.maxConns = -1;
        }
    }

    public void setMaxConnsPerRoute(int maxConnsPerRoute) {
        this.connectionManager = null;
        this.maxConnsPerRoute = maxConnsPerRoute;
    }

    public void setMaxConns(int maxConns) {
        this.connectionManager = null;
        this.maxConns = maxConns;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public void setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void useLaxRedirectStrategy() {
        this.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
    }

    public void setRedirectStrategy(RedirectStrategy strategy) {
        this.redirectStrategy = strategy;
    }

    public DefaultHttpClient buildClient() {
        ClientConnectionManager ccm;
        if (this.connectionManager == null) {
            int maxConnsPerRoute = this.maxConnsPerRoute;
            int maxConns = this.maxConns;
            if (maxConnsPerRoute < 0) {
                maxConnsPerRoute = 20;
            }
            if (maxConns < 0) {
                maxConns = 100;
            }
            if (maxConns < maxConnsPerRoute) {
                maxConns = maxConnsPerRoute;
            }
            SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();
            PoolingClientConnectionManager pool = new PoolingClientConnectionManager(schemeRegistry);
            pool.setDefaultMaxPerRoute(maxConnsPerRoute);
            pool.setMaxTotal(maxConns);
            ccm = pool;
        } else {
            ccm = this.connectionManager;
        }
        Scheme openTlsScheme = this.buildTLSScheme();
        ccm.getSchemeRegistry().register(openTlsScheme);
        PreemptiveAuthHttpClient client = new PreemptiveAuthHttpClient(ccm);
        HttpParams params = client.getParams();
        CredentialsProvider credentialProvider = client.getCredentialsProvider();
        params.removeParameter("http.socket.buffer-size");
        int timeout = new TimeoutHelper().getTimeout(this.timeoutMillis);
        if (timeout > 0) {
            params.setParameter("http.socket.timeout", (Object)timeout);
            params.setParameter("http.connection.timeout", (Object)timeout);
        }
        params.setBooleanParameter("http.socket.reuseaddr", true);
        params.setBooleanParameter("http.tcp.nodelay", true);
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            params.setParameter("http.route.default-proxy", (Object)proxy);
            if (StringUtils.isNotEmpty((CharSequence)this.proxyUsername)) {
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                AuthScope proxyScope = new AuthScope(this.proxyHost, this.proxyPort);
                credentialProvider.setCredentials(proxyScope, (Credentials)proxyCredentials);
            }
        }
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.username, this.password);
            credentialProvider.setCredentials(AuthScope.ANY, (Credentials)clientCredentials);
            client.setPreemptiveAuthentication(this.preemptiveAuthentication);
        }
        client.setRedirectStrategy(this.redirectStrategy);
        if (this.idleConnectionTimeout > 0L) {
            new ConnectionCleaner((Object)client, this.idleConnectionTimeout).start();
        }
        return client;
    }

    private Scheme buildTLSScheme() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            if (this.trustAllCerts) {
                sslContext.init(null, new TrustManager[]{new OpenX509TrustManager()}, null);
            } else {
                sslContext.init(null, null, null);
            }
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        String[] supportedProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        FlexibleSSLSocketFactory flexibleSSLSocketFactory = new FlexibleSSLSocketFactory(factory, supportedProtocols);
        X509HostnameVerifier hostNameVerifier = null;
        if (this.trustAllCerts) {
            hostNameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        }
        org.apache.http.conn.ssl.SSLSocketFactory schemeSocketFactory = new org.apache.http.conn.ssl.SSLSocketFactory((SSLSocketFactory)flexibleSSLSocketFactory, hostNameVerifier);
        Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)schemeSocketFactory);
        return scheme;
    }
}

