/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.DeployTools
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

import org.apache.http.HttpResponse;

import com.urbancode.air.AirPluginTool
import com.urbancode.commons.util.IO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;

public class HttpHelper {
    def apTool
    def props = []
    def charset = IO.utf8()
    DefaultHttpClient client

    public HttpHelper(def apToolIn) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        HttpClientBuilder builder = new HttpClientBuilder()
        builder.setPreemptiveAuthentication(true)
        builder.setUsername(apTool.getAuthTokenUsername())
        builder.setPassword(apTool.getAuthToken())
        if(props['proxyHost']) {
            def proxyPort = Integer.parseInt(props['proxyPort'])
            builder.setProxyHost(props['proxyHost'])
            builder.setProxyPort(proxyPort)
            if(props['proxyUser']) {
                builder.setProxyUsername(props['proxyUser'])
                builder.setProxyPassword(props['proxyPass'])
            }
        }
        client = builder.buildClient()
    }

    public HttpHelper(def apToolIn, def username, def password) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        HttpClientBuilder builder = new HttpClientBuilder()
        builder.setPreemptiveAuthentication(true)
        builder.setUsername(username)
        builder.setPassword(password)
        if(props['proxyHost']) {
            def proxyPort = Integer.parseInt(props['proxyPort'])
            builder.setProxyHost(props['proxyHost'])
            builder.setProxyPort(proxyPort)
            if(props['proxyUser']) {
                builder.setProxyUsername(props['proxyUser'])
                builder.setProxyPassword(props['proxyPass'])
            }
        }
        client = builder.buildClient()

    }

    public String getBody(HttpResponse response)
    throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            Reader reader = IO.reader(body, charset);
            try {
                IO.copy(reader, builder);
            }
            finally {
                reader.close();
            }
        }
        return builder.toString();
    }

    public void setCharset(String charsetName) {
        charset = Charset.forName(charsetName);
    }
}
