/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.DimensionsClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute() {
        block22: {
            File tempDir;
            block21: {
                tempDir = null;
                Properties props = new Properties();
                props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                PropertyConfigurator.configure((Properties)props);
                Properties agentProps = new Properties();
                agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                String charsetName = agentProps.getProperty("system.default.encoding");
                Charset charset = null;
                if (charsetName != null) {
                    charset = Charset.forName(charsetName);
                }
                String extensionString = this.inputProperties.getProperty("extensions");
                String[] extensions = new String[]{};
                if (extensionString != null) {
                    extensions = extensionString.split(",");
                    for (int i = 0; i < extensions.length; ++i) {
                        extensions[i] = extensions[i].trim();
                    }
                }
                String componentName = this.inputProperties.getProperty("componentName");
                String dimensionsUser = this.inputProperties.getProperty("username");
                String dimensionsPassword = this.inputProperties.getProperty("password");
                String dbName = this.inputProperties.getProperty("dbName");
                String dbConn = this.inputProperties.getProperty("dbConn");
                String server = this.inputProperties.getProperty("server");
                String productSpec = this.inputProperties.getProperty("product");
                String baseline = this.inputProperties.getProperty("specificSpec");
                String[] includes = this.splitLines(this.inputProperties.getProperty("includes"));
                boolean overwriteTimestamp = Boolean.valueOf(this.inputProperties.getProperty("overwriteTimestamp"));
                if (includes.length == 0) {
                    includes = new String[]{"**/*"};
                }
                String[] excludes = this.splitLines(this.inputProperties.getProperty("excludes"));
                boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                String username = "PasswordIsAuthToken";
                String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                String webUrl = System.getenv("AH_WEB_URL");
                URI url = new URI(webUrl);
                VersionClient versionClient = new VersionClient(url, username, password);
                ComponentClient componentClient = new ComponentClient(url, username, password);
                DimensionsClient dimensionsClient = new DimensionsClient(dimensionsUser, dimensionsPassword, dbName, dbConn, server);
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                if (StringUtils.isEmpty((String)baseline)) {
                    baseline = dimensionsClient.getLatestBaselineForPart(productSpec);
                }
                boolean hasVersion = versions.contains(baseline);
                System.out.println("Baseline from Dimensions: " + baseline);
                if (!hasVersion) {
                    System.out.println("Creating new version");
                    String versionId = versionClient.createVersion(componentName, baseline, " ", true).toString();
                    this.outputProperties.setProperty("VersionID", versionId);
                    if (isUseVFS) {
                        System.out.println("Uploading files to VFS");
                        tempDir = File.createTempFile("dim", "");
                        tempDir.delete();
                        tempDir.mkdirs();
                        dimensionsClient.downloadBaseline(baseline, "", tempDir, overwriteTimestamp);
                        versionClient.addVersionFiles(componentName, versionId, tempDir, "", includes, excludes, false, true, charset, extensions);
                    } else {
                        System.out.println(String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    versionClient.markImportFinished(componentName, versionId);
                    break block21;
                }
                System.out.println(String.format("UCD already contains version %s", baseline));
            }
            try {
                if (tempDir != null && tempDir.exists()) {
                    IO.delete(tempDir);
                }
                break block22;
            }
            catch (IOException e) {
                System.err.println(String.format("Unable to delete download directory: %s", e));
            }
            break block22;
            catch (Exception e) {
                int n;
                try {
                    System.err.println(String.format("Error creating new version: %s", e.getMessage()));
                    n = 1;
                }
                catch (Throwable throwable) {
                    try {
                        if (tempDir != null && tempDir.exists()) {
                            IO.delete(tempDir);
                        }
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("Unable to delete download directory: %s", e2));
                    }
                    throw throwable;
                }
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete(tempDir);
                    }
                }
                catch (IOException e3) {
                    System.err.println(String.format("Unable to delete download directory: %s", e3));
                }
                return n;
            }
        }
        return 0;
    }

    private String[] splitLines(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        if (string != null) {
            BufferedReader in = IO.buffer(IO.reader(string));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    lines.add(line);
                }
            }
            catch (IOException impossible) {
                throw new RuntimeException(impossible);
            }
        }
        return lines.toArray(new String[lines.size()]);
    }
}

