/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.serena.dmclient.api.Baseline;
import com.serena.dmclient.api.DimensionsConnection;
import com.serena.dmclient.api.DimensionsConnectionDetails;
import com.serena.dmclient.api.DimensionsConnectionManager;
import com.serena.dmclient.api.DimensionsObjectFactory;
import com.serena.dmclient.api.Filter;
import com.serena.dmclient.api.Project;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DimensionsClient {
    private DimensionsConnection connection;
    private DimensionsConnectionDetails details = new DimensionsConnectionDetails();

    public DimensionsClient(String username, String password, String dbName, String dbConnection, String server) {
        this.details.setUsername(username);
        this.details.setPassword(password);
        this.details.setDbName(dbName);
        this.details.setDbConn(dbConnection);
        this.details.setServer(server);
        this.connection = DimensionsConnectionManager.getConnection((DimensionsConnectionDetails)this.details);
    }

    public String[] listProjects() {
        ArrayList<String> projectList = new ArrayList<String>();
        List projects = this.getObjectFactory().getProjects(null);
        for (Project proj : projects) {
            projectList.add(proj.getName());
        }
        return projectList.toArray(new String[0]);
    }

    public String[] listBaselines() {
        ArrayList<String> baselineNameList = new ArrayList<String>();
        List baselineList = this.getObjectFactory().getBaselines(null);
        for (Baseline baseline : baselineList) {
            baselineNameList.add(baseline.getName());
        }
        return baselineNameList.toArray(new String[0]);
    }

    public void downloadBaseline(String baselineName, String directoryOffset, File toDir, boolean overwriteTimestamp) throws IOException {
        Filter baseLineFilter = new Filter();
        baseLineFilter.criteria().add(new Filter.Criterion(-1102, (Object)baselineName.toUpperCase(), 8));
        List baselineList = this.getObjectFactory().getBaselines(baseLineFilter);
        if (baselineList.size() < 1) {
            throw new IllegalArgumentException("Baseline with name " + baselineName + " not found!");
        }
        if (baselineList.size() > 1) {
            throw new IllegalArgumentException("More than 1 Baseline with name " + baselineName + " found!");
        }
        if (directoryOffset == null) {
            directoryOffset = "";
        }
        Baseline base = (Baseline)baselineList.get(0);
        base.downloadExec(directoryOffset, toDir.getAbsolutePath(), null, File.createTempFile("dimensions", ".log").getAbsolutePath(), true, overwriteTimestamp, true, true, false);
    }

    public String[] getBaselinesForPart(String partSpec) {
        ArrayList<String> baselines = new ArrayList<String>();
        Filter baseLineFilter = new Filter();
        baseLineFilter.criteria().add(new Filter.Criterion(-1606, (Object)partSpec, 8));
        List baselineList = this.getObjectFactory().getBaselines(baseLineFilter);
        for (Baseline base : baselineList) {
            baselines.add(base.getName());
        }
        return baselines.toArray(new String[0]);
    }

    public String getLatestBaselineForPart(String partSpec) {
        Filter baseLineFilter = new Filter();
        baseLineFilter.criteria().add(new Filter.Criterion(-1606, (Object)partSpec, 8));
        baseLineFilter.criteria().add(new Filter.Order(-1201, -1));
        List baselineList = this.getObjectFactory().getBaselines(baseLineFilter);
        return ((Baseline)baselineList.get(0)).getName();
    }

    public void downloadLatestBaselineForPart(String partSpec, String dircetoryOffset, File toDir, boolean overwriteTimestamp) throws IOException {
        String latest = this.getLatestBaselineForPart(partSpec);
        this.downloadBaseline(latest, dircetoryOffset, toDir, overwriteTimestamp);
    }

    private DimensionsConnection getConnection() {
        return this.connection;
    }

    private DimensionsObjectFactory getObjectFactory() {
        return this.getConnection().getObjectFactory();
    }
}

