/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.persistence.hibernate.HibernateUtil;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.context.ThreadLocalSessionContext;

public class HibernateSessionRequestFilter
implements Filter {
    private static Logger logger = Logger.getLogger(HibernateSessionRequestFilter.class);
    private SessionFactory sf;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        try {
            logger.debug("Starting a database transaction");
            this.sf.getCurrentSession().beginTransaction();
            chain.doFilter(request, response);
            if (this.sf.getCurrentSession().getTransaction().isActive()) {
                if (request.getAttribute("errors") == null) {
                    logger.debug("Committing the database transaction");
                    this.sf.getCurrentSession().getTransaction().commit();
                } else {
                    logger.debug("Transaction rolled back - errors found in the request");
                    this.sf.getCurrentSession().getTransaction().rollback();
                    this.sf.getCurrentSession().getTransaction().begin();
                }
            } else {
                logger.debug("No active transaction found");
            }
        }
        catch (StaleObjectStateException staleEx) {
            logger.error("This interceptor does not implement optimistic concurrency control!");
            logger.error("Your application will not work until you add compensation actions!");
            logger.error(staleEx.getMessage(), staleEx);
            throw staleEx;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                if (this.sf.getCurrentSession().getTransaction().isActive()) {
                    logger.debug("Trying to rollback database transaction after exception");
                    this.sf.getCurrentSession().getTransaction().rollback();
                }
            }
            catch (Throwable rbEx) {
                logger.error("Could not rollback transaction after exception!", rbEx);
            }
            this.sf.getCurrentSession().close();
            throw new ServletException(ex);
        }
        finally {
            SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
            if (sessionFactory != null) {
                ThreadLocalSessionContext.unbind((SessionFactory)sessionFactory);
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        logger.debug("Initializing filter...");
        logger.debug("Obtaining SessionFactory from static HibernateUtil singleton");
        this.sf = HibernateUtil.getSessionFactory();
        logger.info("Filter initialized");
    }

    public void destroy() {
        logger.info("Filter destroyed");
    }
}

