#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool

final def apTool = new AirPluginTool(this.args[0], this.args[1])
def m_interfaces = new iControl.Interfaces();
final def props = apTool.getStepProperties()

final def serverUrlArray = props['serverURL']?.split('://') as String[]
final def username = props['username']
final def password = props['password']
final def nodeAddress = props['nodeAddress'] as String
final def partitionName = props['partition']

try {
    def connectionString = serverUrlArray.length > 1? serverUrlArray[1] : serverUrlArray[0]
    if (connectionString.endsWith('/'))
    connectionString = connectionString.substring(0, connectionString.length() - 1)
    
    //m_interfaces_initialize must be called to use its methods
    m_interfaces.initialize(connectionString, username, password)
    def partitionBinding = m_interfaces.getManagementPartition()
    partitionBinding.set_active_partition(partitionName)
    def nodeAddressBinding = m_interfaces.getLocalLBNodeAddress()
    String[] nodeAddressArray = [nodeAddress]
    iControl.CommonEnabledState[] enabledStatus = [iControl.CommonEnabledState.STATE_ENABLED]
    nodeAddressBinding.set_session_enabled_state(nodeAddressArray, enabledStatus)
    nodeAddressBinding.set_monitor_state(nodeAddressArray, enabledStatus)
    println "Enabled node ${nodeAddress} across all pools and ports"
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}
