/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

try {
    def stepStatus
    F5Node node = new F5Node(props)

    println "Checking Node Enabled Status..."
    if (node.getNodeEnabledStatus() != node.POSITIVE) {
        println "Failing step at Node Enabled"
        stepStatus = "Failure"
    }

    println "Checking Node Monitor Status..."
    if (node.getNodeMonitorStatus() != node.POSITIVE) {
        println "Failing step at Monitor Enabled"
        stepStatus = "Failure"
    }

    println "Check Node Availability..."
    if (node.getNodeAvailability() != node.POSITIVE) {
        println "Failing step at Node Availability"
        stepStatus = "Failure"
    }

    apTool.setOutputProperty("Status", stepStatus ?: "Success")
    apTool.setOutputProperties()
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}