/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Class
import com.urbancode.air.plugin.f5.F5DataGroupFile

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

def failStrategy = props['failStrategy']
def exitVal = 1
try {
    F5Class dataGroup = new F5Class(props)
    def name = props['name']
    name = dataGroup.appendFolderNames(name)[0]
    def file_name = props['file_name']
    file_name = dataGroup.appendFolderNames(file_name)[0]
    def file_format = props['file_format']
    def file_mode = props['file_mode']
    println "If the External Data Group already exists, the selected strategy is: ${failStrategy}"

    // Create the External Data Group
    // 0 == Data Group successfully created
    // 1 == Data Group already exists
    // Crash gracefully otherwise
    exitVal = dataGroup.createExternalClass(name, file_name, file_format, file_mode)
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}

// Crash if failStrategy == 'FAIL'
if (exitVal == 1 && failStrategy == 'FAIL') {
    System.exit(1)
}