/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Pool

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

final def poolName = props['poolName']
final def lbMethod = props['lbMethod']
final def monitorList = props['monitors']
final def allowSnat = props['allowSnat']
final def allowNat = props['allowNat']
final def serviceDownAction = props['serviceDownAction']
final def slowRampTime = props['slowRampTime']
final def clientIpTos = props['clientIpTos']
final def serverIpTos = props['serverIpTos']
final def clientLinkQos = props['clientLinkQos']
final def serverLinkQos = props['serverLinkQos']

try {
    F5Pool pool = new F5Pool(props)
    pool.createPool(lbMethod)

    // Configure pool settings
    pool.removePoolMonitors()
    if (monitorList) {
        def monitorArray = monitorList.split('\n').join(',').split(',').findAll{ it && it.trim().size() > 0} as String[]
        monitorArray.each {it.trim()}
        pool.addPoolMonitors(monitorArray)
    }

    pool.setPoolAllowSNATState(allowSnat)
    pool.setPoolAllowNATState(allowNat)
    pool.setPoolActionOnServiceDown(serviceDownAction)
    pool.setPoolSlowRampTime(slowRampTime)

    if (clientIpTos) {
        pool.setPoolClientIPTOS(clientIpTos)
    }

    if (serverIpTos) {
        pool.setPoolServerIPTOS(serverIpTos)
    }

    if (clientLinkQos) {
        pool.setPoolClientLinkQOS(clientLinkQos)
    }

    if (serverLinkQos) {
        pool.setPoolServerLinkQOS(serverLinkQos)
    }
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}
