/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5Node

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
final def waitTime = (props['waitForConnections'])?Long.valueOf(props['waitForConnections']):0
final def sleepInterval = (props['sleepInterval'])?Long.valueOf(props['sleepInterval']):5
final def forceOffline = Boolean.valueOf(props['forceOffline'])

try {
    F5Node node = new F5Node(props)
    node.disableNode()

    if (forceOffline){
        node.disableNodeMonitor()
    }

    if (waitTime) {
        println "Beginning to wait for connections to close."
        def allowedTime = System.currentTimeMillis() + waitTime * 1000
        def currentConnections = node.getNodeActiveConnections()
        while(currentConnections > 0) {
            if (System.currentTimeMillis() > allowedTime) {
                println "Allowed time for waiting for connections was exceeded. Bringing the node down now."
                return;
            }
            println("Waiting for $currentConnections to close, sleep for $sleepInterval second(s)")
            sleep(sleepInterval * 1000, {println("Waiting aborted!"); return true})
            currentConnections = node.getNodeActiveConnections()
        }
    }
    println("All connections closed, done waiting.")
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}