/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.f5.F5iRule

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

def exitVal = 1
try {
    F5iRule iRule = new F5iRule(props)
    String[] iRuleNames = iRule.text2StringArray(props['iRuleNames'])
    def existingiRuleNames = []

    // If iRuleNames is null, get the entire iRule list
    if (!iRuleNames){
        existingiRuleNames = iRule.getiRuleList()
    }
    // Else, iterate through the given list and confirm iRules exist
    else {
        iRuleNames = iRule.appendFolderNames(iRuleNames)
        String[] currentiRules = iRule.getiRuleList()
        for (name in iRuleNames) {
            if (iRule.doesiRuleExist(name, currentiRules)) {
                existingiRuleNames << name
            }
            else {
                println "WARNING: iRule ${name} does not exist."
                exitVal = 1
            }
        }
    }

    // Get the iRule Statistics
    def iRuleStatistics = iRule.getiRuleStatistics(existingiRuleNames)

    // Print the iRule statistics to standard out
    iRule.printRuleStatistics(iRuleStatistics)
}
catch (Exception e) {
    e.printStackTrace()
    System.exit(1)
}

// Crash on non-existing iRule if failStrategy == 'FAIL'
def failStrategy = props['failStrategy']
println "If an iRule does not exist, the selected fail strategy is: ${failStrategy}"
if (exitVal == 1 && failStrategy == 'FAIL') {
    System.exit(1)
}